#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.UnitTests
{


	/// <summary>
	/// Code for Calling sprocs 
	/// </summary>
	public class SprocHelper
	{		

		/// <summary>
		/// Creates DataTable for spInsertAddress
		/// </summary>
		/// <param name="addressGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertAddressSprocTable(Guid addressGuid)
		{
			DataTable dt = new DataTable(TABLES.Address.TableName);

			dt.Columns.Add(TABLES.Address.AddressGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Address.AddressLine1, typeof(string));
			dt.Columns.Add(TABLES.Address.AddressCity, typeof(string));
			dt.Columns.Add(TABLES.Address.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.Address.AddressGuid] = addressGuid;
			dr[TABLES.Address.AddressLine1] = "742 Evergreen Terrace";
			dr[TABLES.Address.AddressCity] = "Springfield";
			dr[TABLES.Address.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;

			dt.Rows.Add(dr);
			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertDailyControl
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertDailyControlSprocTable()
		{
			DataTable dt = new DataTable(TABLES.DailyControl.TableName);

			dt.Columns.Add(TABLES.DailyControl.DailyControlGuid, typeof(Guid));
			dt.Columns.Add(TABLES.DailyControl.NumberOfRacks, typeof(int));
			dt.Columns.Add(TABLES.DailyControl.RackNamesIndicator, typeof(bool));
			dt.Columns.Add(TABLES.DailyControl.DailyAlertTime, typeof(DateTime));
			dt.Columns.Add(TABLES.DailyControl.CommercialTemplateIndicator, typeof(bool));
			dt.Columns.Add(TABLES.DailyControl.PrimaryEnhancementMediaId, typeof(int));
			dt.Columns.Add(TABLES.DailyControl.SecondaryEnhancementMediaId, typeof(int));
			dt.Columns.Add(TABLES.DailyControl.Comments, typeof(string));
			dt.Columns.Add(TABLES.DailyControl.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.DailyControl.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.DailyControl.LastUpdateUser, typeof(string));

			DataRow dr = dt.NewRow();
			dr[TABLES.DailyControl.DailyControlGuid] = Guid.NewGuid();
			dr[TABLES.DailyControl.NumberOfRacks] = new Random().Next(1,26);
			dr[TABLES.DailyControl.RackNamesIndicator] = true;
			dr[TABLES.DailyControl.DailyAlertTime] = DateTime.Now;
			dr[TABLES.DailyControl.CommercialTemplateIndicator] = false;
			dr[TABLES.DailyControl.PrimaryEnhancementMediaId] = new Random().Next(1,3);
			dr[TABLES.DailyControl.SecondaryEnhancementMediaId] = new Random().Next(1,3);
			dr[TABLES.DailyControl.Comments] = DateTime.Now.ToString();
			dr[TABLES.DailyControl.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.DailyControl.RecordStatusCode] = "A";
			dr[TABLES.DailyControl.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertDailyQcWorklistSprocTable
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertDailyQcWorklistSprocTable(Guid rackGuid)
		{
			DataTable dt = new DataTable(TABLES.DailyQcWorklist.TableName);

			dt.Columns.Add(TABLES.DailyQcWorklist.DailyQcWorklistGuid, typeof(Guid));
			dt.Columns.Add(TABLES.DailyQcWorklist.RackGuid, typeof(Guid));
			dt.Columns.Add(TABLES.DailyQcWorklist.PartiallyTestedIndicator, typeof(bool));
			dt.Columns.Add(TABLES.DailyQcWorklist.DailyUseIndicator, typeof(bool));
			dt.Columns.Add(TABLES.DailyQcWorklist.DailyQcExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLES.DailyQcWorklist.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.DailyQcWorklist.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.DailyQcWorklist.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.DailyQcWorklist.DailyQcWorklistGuid] = Guid.NewGuid();
			dr[TABLES.DailyQcWorklist.RackGuid] = rackGuid;
			dr[TABLES.DailyQcWorklist.PartiallyTestedIndicator] = false;
			dr[TABLES.DailyQcWorklist.DailyUseIndicator] = false;
			dr[TABLES.DailyQcWorklist.DailyQcExpirationDate] = DateTime.Now.AddDays(14);
			dr[TABLES.DailyQcWorklist.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.DailyQcWorklist.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.DailyQcWorklist.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}



		/// <summary>
		/// Creates a DataTable for spInsertEquipment
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertEquipmentSprocTable(Guid equipGuid, Guid addressGuid)
		{
			DataTable dt = new DataTable(TABLES.Equipment.TableName);

			dt.Columns.Add(TABLES.Equipment.EquipmentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Equipment.EquipmentName, typeof(string));
			dt.Columns.Add(TABLES.Equipment.EquipmentType, typeof(string));
			dt.Columns.Add(TABLES.Equipment.ManufacturerName, typeof(string));
			dt.Columns.Add(TABLES.Equipment.AddressGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Equipment.SerialNumber, typeof(string));
			dt.Columns.Add(TABLES.Equipment.ReceiptDate, typeof(DateTime));
			dt.Columns.Add(TABLES.Equipment.LocalIdentifier, typeof(string));
			dt.Columns.Add(TABLES.Equipment.OutOfServiceIndicator, typeof(bool));
			dt.Columns.Add(TABLES.Equipment.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.Equipment.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.Equipment.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.Equipment.EquipmentGuid] = equipGuid;
			dr[TABLES.Equipment.EquipmentName] = DateTime.Now.ToString();
			dr[TABLES.Equipment.EquipmentType] = "Springy";
			dr[TABLES.Equipment.ManufacturerName] = DateTime.Now.ToString();
			dr[TABLES.Equipment.AddressGuid] = addressGuid;
			dr[TABLES.Equipment.SerialNumber] = DateTime.Now.ToString("ddmmyyssmmhh");
			dr[TABLES.Equipment.ReceiptDate] = DateTime.Now;
			dr[TABLES.Equipment.LocalIdentifier] = "123";
			dr[TABLES.Equipment.OutOfServiceIndicator] = false;
			dr[TABLES.Equipment.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.Equipment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.Equipment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInactivateBloodUnitShipment
		/// </summary>
		/// <param name="rowVersion"></param>
		/// <param name="unitShipmentGuid"></param>
		/// <returns></returns>
		public static DataTable GetInactivateBloodUnitShipmentSprocTable(Guid unitShipmentGuid, byte[] rowVersion)
		{
			DataTable dtShipment = new DataTable(TABLES.BloodUnitShipment.TableName);
			
			dtShipment.Columns.Add(TABLES.BloodUnitShipment.BloodUnitShipmentGuid, typeof(Guid));
			dtShipment.Columns.Add(TABLES.BloodUnitShipment.LastUpdateFunctionId, typeof(int));
			dtShipment.Columns.Add(TABLES.BloodUnitShipment.RowVersion, typeof(byte[]));
			
			DataRow dtRow = dtShipment.NewRow();
			dtRow[TABLES.BloodUnitShipment.BloodUnitShipmentGuid] = unitShipmentGuid;
			dtRow[TABLES.BloodUnitShipment.LastUpdateFunctionId] = Common.UpdateFunction.UnitTests;
			dtRow[TABLES.BloodUnitShipment.RowVersion] = rowVersion;
			dtShipment.Rows.Add(dtRow);

			return(dtShipment);
		}

		/// <summary>
		/// Creates a DataTable for spInactivateBloodUnitAntigen
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInactivateBloodUnitAntigenSprocTable(DataTable dtBloodUnitAntigens, BOL.BloodUnit bloodUnit)
		{
			DataTable dtBloodUnitAntigen = new DataTable(TABLES.BloodUnitAntigen.TableName);
			dtBloodUnitAntigen.Columns.Add(TABLES.BloodUnitAntigen.BloodUnitGuid, typeof(Guid));
			dtBloodUnitAntigen.Columns.Add(TABLES.BloodUnitAntigen.Comments, typeof(string));
			dtBloodUnitAntigen.Columns.Add(TABLES.BloodUnitAntigen.DivisionCode, typeof(string));
			dtBloodUnitAntigen.Columns.Add(TABLES.BloodUnitAntigen.LastUpdateDate, typeof(DateTime));
			dtBloodUnitAntigen.Columns.Add(TABLES.BloodUnitAntigen.LastUpdateUser, typeof(string));
			dtBloodUnitAntigen.Columns.Add(TABLES.BloodUnitAntigen.LastUpdateFunctionId, typeof(int));
			dtBloodUnitAntigen.Columns.Add(TABLES.BloodUnitAntigen.RowVersion, typeof(byte[]));
			
			foreach(DataRow row in dtBloodUnitAntigens.Rows)
			{
				DataRow dtAntigenRow = dtBloodUnitAntigen.NewRow();
				dtAntigenRow[TABLES.BloodUnitAntigen.BloodUnitGuid] = bloodUnit.BloodUnitGuid;
				dtAntigenRow[TABLES.BloodUnitAntigen.Comments] = "UNIT TEST";
				dtAntigenRow[TABLES.BloodUnitAntigen.DivisionCode] = UnitTestConfig.TestDivisionCode;
				dtAntigenRow[TABLES.BloodUnitAntigen.LastUpdateDate] = gov.va.med.vbecs.DAL.VbecsDateTime.GetDivisionCurrentDateTime();
				dtAntigenRow[TABLES.BloodUnitAntigen.LastUpdateUser] = Common.LogonUser.LogonUserName;
				dtAntigenRow[TABLES.BloodUnitAntigen.LastUpdateFunctionId] = Common.UpdateFunction.UnitTests;
				dtAntigenRow[TABLES.BloodUnitAntigen.RowVersion] = (byte[])row[TABLES.BloodUnitAntigen.RowVersion];				
				dtBloodUnitAntigen.Rows.Add(dtAntigenRow);
			}

			return(dtBloodUnitAntigen);
		}

		/// <summary>
		/// Creates a DataTable for spInsertEquipmentMaintenance
		/// </summary>
		/// <param name="emGuid"></param>
		/// <param name="equipGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertEquipmentMaintenanceSprocTable(Guid emGuid, Guid equipGuid)
		{
			DataTable dt = new DataTable(TABLES.EquipmentMaintenance.TableName);

			dt.Columns.Add(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid, typeof(Guid));
			dt.Columns.Add(TABLES.EquipmentMaintenance.EquipmentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.EquipmentMaintenance.MaintenanceType, typeof(Guid));
			dt.Columns.Add(TABLES.EquipmentMaintenance.MaintenanceDate, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.MaintenanceResults, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.Equipment.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid] = emGuid;
			dr[TABLES.EquipmentMaintenance.EquipmentGuid] = equipGuid;
			//dr[TABLES.EquipmentMaintenance.MaintenanceType] = "Good";
		    dr[TABLES.EquipmentMaintenance.MaintenanceType] = Guid.NewGuid();
			dr[TABLES.EquipmentMaintenance.MaintenanceDate] = DateTime.Now.AddDays(-5);
			dr[TABLES.EquipmentMaintenance.MaintenanceResults] = "I am happy";
			dr[TABLES.EquipmentMaintenance.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.EquipmentMaintenance.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.Equipment.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertAntiseraOrderedTest 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertAntiseraOrderedTestSprocTable(Guid aotGuid, Guid otGuid, Guid rackLotGuid)
		{
			DataTable dt = new DataTable(TABLES.AntiseraOrderedTest.TableName);

			dt.Columns.Add(TABLES.AntiseraOrderedTest.AntiseraOrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraOrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraOrderedTest.RackLotGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraOrderedTest.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.AntiseraOrderedTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.AntiseraOrderedTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.AntiseraOrderedTest.AntiseraOrderedTestGuid] = aotGuid;
			dr[TABLES.AntiseraOrderedTest.OrderedTestGuid] = otGuid;
			dr[TABLES.AntiseraOrderedTest.RackLotGuid] = rackLotGuid;
			dr[TABLES.AntiseraOrderedTest.RecordStatusCode] = "A";
			dr[TABLES.AntiseraOrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.AntiseraOrderedTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertAntiseraUnitTest 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertAntiseraUnitTestSprocTable(Guid autGuid, Guid rackLotGuid)
		{
			DataTable dt = new DataTable(TABLES.AntiseraUnitTest.TableName);

			dt.Columns.Add(TABLES.AntiseraUnitTest.AntiseraUnitTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraUnitTest.RackLotGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraUnitTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.AntiseraUnitTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.AntiseraUnitTest.AntiseraUnitTestGuid] = autGuid;
			dr[TABLES.AntiseraUnitTest.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			dr[TABLES.AntiseraUnitTest.RackLotGuid] = rackLotGuid;
			dr[TABLES.AntiseraUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.AntiseraUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertAntiseraWorklist
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertAntiseraWorklistSprocTable()
		{
			DataTable dt = new DataTable(TABLES.AntiseraWorklist.TableName);

			dt.Columns.Add(TABLES.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraWorklist.WorklistName, typeof(string));
			dt.Columns.Add(TABLES.AntiseraWorklist.WorklistCreateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.AntiseraWorklist.TestingMethodCode, typeof(string));
			dt.Columns.Add(TABLES.AntiseraWorklist.AutoInstrumentName, typeof(string));
			dt.Columns.Add(TABLES.AntiseraWorklist.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.AntiseraWorklist.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.AntiseraWorklist.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.AntiseraWorklist.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.AntiseraWorklist.AntiseraWorklistGuid] = Guid.NewGuid();
			dr[TABLES.AntiseraWorklist.WorklistName] = DateTime.Now;
			dr[TABLES.AntiseraWorklist.WorklistCreateDate] = DateTime.Now.ToString();
			dr[TABLES.AntiseraWorklist.TestingMethodCode] = "A";
			dr[TABLES.AntiseraWorklist.AutoInstrumentName] = DateTime.Now.ToString();
			dr[TABLES.AntiseraWorklist.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.AntiseraWorklist.RecordStatusCode] = "A";
			dr[TABLES.AntiseraWorklist.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.AntiseraWorklist.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertAntiseraWorklistTyping 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertAntiseraWorklistTypingSprocTable()
		{
			DataTable dt = new DataTable(TABLES.AntiseraWorklistTyping.TableName);

			dt.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid, typeof(Guid));
			dt.Columns.Add(TABLES.AntiseraWorklistTyping.OrderableTestId, typeof(int));
			dt.Columns.Add(TABLES.AntiseraWorklistTyping.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.AntiseraWorklistTyping.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.AntiseraWorklistTyping.AntiseraWorklistGuid] = Guid.NewGuid();
			dr[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = Guid.NewGuid();
			dr[TABLES.AntiseraWorklistTyping.OrderableTestId] = 1;
			dr[TABLES.AntiseraWorklistTyping.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.AntiseraWorklistTyping.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertBloodUnitAntigen
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertBloodUnitAntigenSprocTable(Guid bloodUnitGuid)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitAntigen.TableName);

			dt.Columns.Add(TABLES.BloodUnitAntigen.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitAntigen.AntigenTypeId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnitAntigen.Positive, typeof(bool));
			dt.Columns.Add(TABLES.BloodUnitAntigen.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitAntigen.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitAntigen.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitAntigen.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitAntigen.BloodUnitGuid] = bloodUnitGuid;
			dr[TABLES.BloodUnitAntigen.AntigenTypeId] = 1;
			dr[TABLES.BloodUnitAntigen.Positive] = true;
			dr[TABLES.BloodUnitAntigen.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.BloodUnitAntigen.RecordStatusCode] = "A";
			dr[TABLES.BloodUnitAntigen.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitAntigen.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertBloodUnitTest 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertBloodUnitTestSprocTable(Guid butGuid, Guid unitGuid, int typeId, string testResult)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitTest.TableName);

			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.BloodTestTypeId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnitTest.TestResultId, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.EntryMethodCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitTest.BloodUnitGuid] = unitGuid;
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = butGuid;
			dr[TABLES.BloodUnitTest.BloodTestTypeId] = typeId;
			dr[TABLES.BloodUnitTest.TestResultId] = testResult;
			dr[TABLES.BloodUnitTest.EntryMethodCode] = 'M';
			dr[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			dr[TABLES.BloodUnitTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertBloodUnitTest for OrderedComponents
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertBloodUnitTestSprocTable2(Guid butGuid, Guid unitGuid, int typeId, string testResult, Guid ouGuid, Guid ocGuid)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitTest.TableName);

			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.OrderedComponentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.RackGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.ReactivityPhaseCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.BloodTestTypeId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnitTest.TestResultId, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.EntryMethodCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitTest.BloodUnitGuid] = unitGuid;
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = butGuid;
			dr[TABLES.BloodUnitTest.OrderedComponentGuid] = ocGuid;
			dr[TABLES.BloodUnitTest.OrderedUnitGuid] = ouGuid;
			if (UnitTestUtil.RunSQLGetDataTable("SELECT * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '589'", false).Rows.Count == 0)
			{
				DataCreator.CreateQCdRack();
			}
			dr[TABLES.BloodUnitTest.RackGuid] = DataCreator.GetRandomRecordGuid(TABLES.Rack.TableName, "RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
			dr[TABLES.BloodUnitTest.ReactivityPhaseCode] = "9";
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = butGuid;
			dr[TABLES.BloodUnitTest.BloodTestTypeId] = typeId;
			dr[TABLES.BloodUnitTest.TestResultId] = testResult;
			dr[TABLES.BloodUnitTest.EntryMethodCode] = 'M';
			dr[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			dr[TABLES.BloodUnitTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertBloodUnitTest for OrderedTests
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertBloodUnitTestSprocTable3(Guid butGuid, Guid unitGuid, int typeId, string testResult, Guid ouGuid, Guid otGuid)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitTest.TableName);

			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.RackGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.ReactivityPhaseCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.BloodTestTypeId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnitTest.TestResultId, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.EntryMethodCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitTest.BloodUnitGuid] = unitGuid;
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = butGuid;
			dr[TABLES.BloodUnitTest.OrderedTestGuid] = otGuid;
			dr[TABLES.BloodUnitTest.OrderedUnitGuid] = ouGuid;
			if (UnitTestUtil.RunSQLGetDataTable("SELECT * FROM Rack WHERE RecordStatusCode = 'A' AND DivisionCode = '589'", false).Rows.Count == 0)
			{
				DataCreator.CreateQCdRack();
			}
			dr[TABLES.BloodUnitTest.RackGuid] = DataCreator.GetRandomRecordGuid(TABLES.Rack.TableName, "RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'");
			dr[TABLES.BloodUnitTest.ReactivityPhaseCode] = "9";
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = butGuid;
			dr[TABLES.BloodUnitTest.BloodTestTypeId] = typeId;
			dr[TABLES.BloodUnitTest.TestResultId] = testResult;
			dr[TABLES.BloodUnitTest.EntryMethodCode] = 'M';
			dr[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			dr[TABLES.BloodUnitTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertIssuedUnit
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertIssuedUnitSprocTable(Guid iuGuid, Guid buGuid, Guid patientGuid)
		{
            //Inactivate any exisitng records to avoid dups TODO: make this better?
		    DataTable dtCheck = UnitTestUtil.RunSQLGetDataTable("SELECT IssuedUnitGuid FROM IssuedUnit WHERE BloodUnitGuid = '" + buGuid.ToString() + "' AND ReturnDateTime IS NULL", false);
            foreach (DataRow drReturn in dtCheck.Rows)
            {
                UnitTestUtil.RunSQL("update issuedunit set returndatetime = getutcdate(), returntechid = 'Heisenberg', returnfromlocationname = 'ABQ', ReturnSatisfactoryIndicator = 1, lastupdatedate = getutcdate() where issuedunitguid = '" + drReturn["IssuedUnitGuid"].ToString() + "'");
            }

		    DataTable dt = new DataTable(TABLES.IssuedUnit.TableName);

			dt.Columns.Add(TABLES.IssuedUnit.IssuedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.IssuedUnit.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.IssuedUnit.IssueDateTime, typeof(DateTime));
			dt.Columns.Add(TABLES.IssuedUnit.IssueTechId, typeof(string));
			dt.Columns.Add(TABLES.IssuedUnit.RemoteStorageIndicator, typeof(bool));
			dt.Columns.Add(TABLES.IssuedUnit.TransporterName, typeof(string));		//50
			dt.Columns.Add(TABLES.IssuedUnit.InPatientLocationIndicator, typeof(bool));
			dt.Columns.Add(TABLES.IssuedUnit.IssueSatisfactoryIndicator, typeof(bool));
			dt.Columns.Add(TABLES.IssuedUnit.IssueToLocationName, typeof(string));
			dt.Columns.Add(TABLES.IssuedUnit.LastUpdateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.IssuedUnit.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnit.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnit.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.IssuedUnit.PatientGuid, typeof(Guid));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.IssuedUnit.IssuedUnitGuid] = iuGuid;
			dr[TABLES.IssuedUnit.BloodUnitGuid] = buGuid;
		    dr[TABLES.IssuedUnit.IssueDateTime] = DateTime.Now.AddHours(-1);    //please dont kill all the unit tests - this was breaking bceparser
			dr[TABLES.IssuedUnit.IssueTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.IssuedUnit.RemoteStorageIndicator] = true;
			dr[TABLES.IssuedUnit.TransporterName] = "Grimdiana Bones";
			dr[TABLES.IssuedUnit.InPatientLocationIndicator] = true;
			dr[TABLES.IssuedUnit.IssueSatisfactoryIndicator] = true;
			dr[TABLES.IssuedUnit.PatientGuid] = patientGuid;
			dr[TABLES.IssuedUnit.IssueToLocationName] = "Blood Shack Baby";
			dr[TABLES.IssuedUnit.LastUpdateDate] = DateTime.Now;
			dr[TABLES.IssuedUnit.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.BloodUnit.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertOrderedUnit
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertOrderedUnitSprocTable(Guid ouGuid, Guid ocGuid, Guid bloodGuid)
		{
			DataTable dt = new DataTable(TABLES.OrderedUnit.TableName);

			dt.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.OrderedComponentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.SelectedDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedUnit.OrderedUnitGuid] = ouGuid;
			if (ocGuid != Guid.Empty)
				dr[TABLES.OrderedUnit.OrderedComponentGuid] = ocGuid;
			dr[TABLES.OrderedUnit.RecordStatusCode] = "A";
			dr[TABLES.OrderedUnit.SelectedDate] = DateTime.Now;
			dr[TABLES.OrderedUnit.BloodUnitGuid] = bloodGuid;
			dr[TABLES.OrderedUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.OrderedUnit.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertOrderedUnit
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertOrderedUnitSprocTable2(Guid ouGuid, Guid ocGuid, Guid bloodGuid, Guid otGuid, string xmResult)
		{
			DataTable dt = new DataTable(TABLES.OrderedUnit.TableName);

			dt.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.OrderedComponentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.SelectedDate, typeof(DateTime));

			dt.Columns.Add(TABLES.OrderedUnit.CrossmatchRequiredIndicator, typeof(bool));
			dt.Columns.Add(TABLES.OrderedUnit.CrossmatchDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedUnit.CrossmatchResultCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.CrossmatchTechId, typeof(string));

			dt.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedUnit.OrderedUnitGuid] = ouGuid;
			if (ocGuid != Guid.Empty) 
				dr[TABLES.OrderedUnit.OrderedComponentGuid] = ocGuid;
			else
			{
				if (otGuid != Guid.Empty)
					dr[TABLES.OrderedUnit.OrderedTestGuid] = otGuid;
			}

			dr[TABLES.OrderedUnit.RecordStatusCode] = "A";
			dr[TABLES.OrderedUnit.SelectedDate] = DateTime.Now;
			dr[TABLES.OrderedUnit.BloodUnitGuid] = bloodGuid;

			dr[TABLES.OrderedUnit.CrossmatchRequiredIndicator] = true;
			dr[TABLES.OrderedUnit.CrossmatchDate] = DateTime.Now;
			dr[TABLES.OrderedUnit.CrossmatchResultCode] = xmResult;
			dr[TABLES.OrderedUnit.CrossmatchTechId] = Common.LogonUser.LogonUserName;

			dr[TABLES.OrderedUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.OrderedUnit.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertOrderedTestSprocTable
		/// </summary>
		/// <param name="otGuid"></param>
		/// <param name="poGuid"></param>
		/// <param name="psGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertOrderedTestSprocTable(Guid otGuid, Guid poGuid, Guid psGuid)
		{
			DataTable dt = new DataTable(TABLES.OrderedTest.TableName);

			dt.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.PatientOrderGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.SpecimenRequiredIndicator, typeof(bool));
			dt.Columns.Add(TABLES.OrderedTest.OrderableTestId, typeof(int));
			dt.Columns.Add(TABLES.OrderedTest.VbecsOrderNumber, typeof(int));
			dt.Columns.Add(TABLES.OrderedTest.OrderStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedTest.OrderedTestGuid] = otGuid;
			dr[TABLES.OrderedTest.PatientOrderGuid] = poGuid;
			dr[TABLES.OrderedTest.PatientSpecimenGuid] = psGuid;
			dr[TABLES.OrderedTest.SpecimenRequiredIndicator] = false;
			dr[TABLES.OrderedTest.OrderableTestId] = new Random().Next(7,10);
			dr[TABLES.OrderedTest.VbecsOrderNumber] = new Random().Next(11111,999999);
			dr[TABLES.OrderedTest.OrderStatusCode] = "V";
			dr[TABLES.OrderedTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.OrderedTest.LastUpdateDate] = DateTime.Now;
			dr[TABLES.OrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertOrderedUnitComment
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertOrderedUnitCommentSprocTable(Guid unitGuid)
		{
			DataTable dt = new DataTable(TABLES.OrderedUnitComment.TableName);

			dt.Columns.Add(TABLES.OrderedUnitComment.OrderedUnitCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnitComment.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnitComment.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnitComment.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedUnitComment.OrderedUnitCommentGuid] = Guid.NewGuid();
			dr[TABLES.OrderedUnitComment.OrderedUnitGuid] = unitGuid;
			dr[TABLES.OrderedUnitComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnitComment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}
		
		/// <summary>
		/// Creates a DataTable for spInsertPatient
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertPatientSprocTable(Guid patientGuid)
		{
			//First, we need to create a patient to merge from and to
			DataTable dt = new DataTable(TABLES.Patient.TableName);

			dt.Columns.Add(TABLES.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Patient.VistaPatientId, typeof(long));
			dt.Columns.Add(TABLES.Patient.PatientSsn, typeof(string));
			dt.Columns.Add(TABLES.Patient.PatientDob, typeof(DateTime));
			dt.Columns.Add(TABLES.Patient.PatientDobCode, typeof(string));
			dt.Columns.Add(TABLES.Patient.PatientLastName, typeof(string));
			dt.Columns.Add(TABLES.Patient.PatientFirstName, typeof(string));
			dt.Columns.Add(TABLES.Patient.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.Patient.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.Patient.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.Patient.PatientGuid] = patientGuid;
			//At the time of unit test coding 5000-6000 were not being used
			dr[TABLES.Patient.VistaPatientId] = SprocHelper.GetVistaPatientId();
			dr[TABLES.Patient.PatientSsn] = new Random().Next(0,999999999).ToString("000000000");
			dr[TABLES.Patient.PatientDob] = DateTime.Now.AddYears(-55);
			dr[TABLES.Patient.PatientDobCode] = "V";
			dr[TABLES.Patient.PatientLastName] = "Simposon";
			dr[TABLES.Patient.PatientFirstName] = "Homer";
			dr[TABLES.Patient.RecordStatusCode] = "A";
			dr[TABLES.Patient.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.Patient.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertPtientOrder
		/// </summary>
		/// <param name="pOrderGuid"></param>
		/// <param name="pTreatmentGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertPatientOrderSprocTable(Guid pOrderGuid, Guid pTreatmentGuid)
		{
			DataTable dt = new DataTable(TABLES.PatientOrder.TableName);

			dt.Columns.Add(TABLES.PatientOrder.PatientOrderGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientOrder.PatientTreatmentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientOrder.OrderGroupNumber, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.OrderReceivedDatetime, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientOrder.OrderPlacedDatetime, typeof(DateTime));

			dt.Columns.Add(TABLES.PatientOrder.OrderingProviderId, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.OrderingProviderLastName, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.OrderingProviderFirstName, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.OrderingHospitalLocation, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.OrderEnteredById, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.OrderEnteredByLastName, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.OrderEnteredByFirstName, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.InformedConsentIndicator, typeof(bool));

			dt.Columns.Add(TABLES.PatientOrder.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientOrder.LastUpdateFunctionId, typeof(int));
			
			//Create data
			DataRow dr = dt.NewRow();
			dr[TABLES.PatientOrder.PatientOrderGuid] = pOrderGuid;
			dr[TABLES.PatientOrder.PatientTreatmentGuid] = pTreatmentGuid;
			dr[TABLES.PatientOrder.OrderGroupNumber] = new Random().Next(1000, 9999).ToString() + new Random().Next(1000,9999).ToString();
			dr[TABLES.PatientOrder.OrderReceivedDatetime] = DateTime.Now;
			dr[TABLES.PatientOrder.OrderPlacedDatetime] = DateTime.Now;

			dr[TABLES.PatientOrder.OrderingProviderId] = new Random().Next(1000, 99999).ToString();
			dr[TABLES.PatientOrder.OrderingProviderLastName] = "SIMPSON";
			dr[TABLES.PatientOrder.OrderingProviderFirstName] = "HOMER";
			dr[TABLES.PatientOrder.OrderingHospitalLocation] = new BOL.Division(Common.LogonUser.LogonUserDivisionCode).DivisionName;
			dr[TABLES.PatientOrder.OrderEnteredById] = new Random().Next(1000, 99999).ToString();
			dr[TABLES.PatientOrder.OrderEnteredByLastName] = "SIMPSON";
			dr[TABLES.PatientOrder.OrderEnteredByFirstName] = "HOMER";
			dr[TABLES.PatientOrder.InformedConsentIndicator] = false;
			
			dr[TABLES.PatientOrder.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.PatientOrder.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientOrder.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertPatientSpecimen
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertPatientSpecimenSprocTable(Guid psGuid, Guid pGuid, string specimenUid)
		{
			DataTable dt = new DataTable(TABLES.PatientSpecimen.TableName);

			dt.Columns.Add(TABLES.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientSpecimen.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenUid, typeof(string));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenCollectionDate, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientSpecimen.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientSpecimen.LastUpdateFunctionId, typeof(int));
			
			//Create a dummy data
			DataRow dr = dt.NewRow();
			dr[TABLES.PatientSpecimen.PatientSpecimenGuid] = psGuid;
			dr[TABLES.PatientSpecimen.PatientGuid] = pGuid;
			dr[TABLES.PatientSpecimen.SpecimenUid] = specimenUid;
			dr[TABLES.PatientSpecimen.SpecimenCollectionDate] = DateTime.Now;
			dr[TABLES.PatientSpecimen.SpecimenExpirationDate] = DateTime.Now.AddDays(5);
			dr[TABLES.PatientSpecimen.SpecimenStatusCode] = "A";
			dr[TABLES.PatientSpecimen.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.PatientSpecimen.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// spInsertPatientTransfusionComment
		/// </summary>
		/// <param name="ptcGuid"></param>
		/// <param name="ptrGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertPatientTransfusionCommentSprocTable(Guid ptcGuid, Guid ptrGuid)
		{
			DataTable dt = new DataTable(TABLES.PatientTransfusionComment.TableName);

			dt.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionComment.PatientTransfusionCommentText, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionComment.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionComment.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionComment.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTransfusionComment.PatientTransfusionCommentGuid] = ptcGuid;
			dr[TABLES.PatientTransfusionComment.PatientTransfusionReactionGuid] = ptrGuid;
			dr[TABLES.PatientTransfusionComment.PatientTransfusionCommentText] = "UT" + DateTime.Now.ToString();
			dr[TABLES.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLES.PatientTransfusionComment.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			dr[TABLES.PatientTransfusionComment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertPatientTransfusion
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertPatientTransfusionSprocTable(Guid ptGuid, Guid patientGuid, Guid bloodUnitGuid)
		{
			//First, we need to create a patient to merge from and to
			DataTable dt = new DataTable(TABLES.PatientTransfusion.TableName);

			dt.Columns.Add(TABLES.PatientTransfusion.PatientTransfusionGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusion.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusion.TransfusionLocation, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusion.LocationIen, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusion.TransfusionStartDateTime, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientTransfusion.TransfusionEndDateTime, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientTransfusion.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusion.InterruptionIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientTransfusion.ReactionIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientTransfusion.ApplicationOfRecordId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusion.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusion.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusion.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTransfusion.PatientTransfusionGuid] = ptGuid;
			dr[TABLES.PatientTransfusion.PatientGuid] = patientGuid;
			dr[TABLES.PatientTransfusion.TransfusionLocation] = "Jamaica";
			dr[TABLES.PatientTransfusion.LocationIen] = "123";
			dr[TABLES.PatientTransfusion.TransfusionStartDateTime] = DateTime.Now;
			dr[TABLES.PatientTransfusion.TransfusionEndDateTime] = DateTime.Now.AddHours(5);
			dr[TABLES.PatientTransfusion.BloodUnitGuid] = bloodUnitGuid;
			dr[TABLES.PatientTransfusion.InterruptionIndicator] = false;
			dr[TABLES.PatientTransfusion.ReactionIndicator] = false;
			dr[TABLES.PatientTransfusion.ApplicationOfRecordId] = 1;
			dr[TABLES.PatientTransfusion.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.PatientTransfusion.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTransfusion.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Get InsertPatientTransfusionReaction Sproc Table
		/// </summary>
		/// <param name="ptrGuid"></param>
		/// <param name="patientGuid"></param>
		/// <param name="otGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertPatientTransfusionReactionSprocTable(Guid ptrGuid, Guid patientGuid, Guid otGuid, Guid preGuid, Guid postGuid)
		{
			DataTable dt = new DataTable(TABLES.PatientTransfusionReaction.TableName);

			dt.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PreSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PostSpecimenGuid, typeof(Guid));

			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = ptrGuid;
			dr[TABLES.PatientTransfusionReaction.PatientGuid] = patientGuid;
			dr[TABLES.PatientTransfusionReaction.OrderedTestGuid] = otGuid;
			dr[TABLES.PatientTransfusionReaction.PreSpecimenNotAvailableIndicator] = true;
			dr[TABLES.PatientTransfusionReaction.PostSpecimenNotAvailableIndicator] = true;
			dr[TABLES.PatientTransfusionReaction.PreSpecimenClericalChecksOkIndicator] = true;
			dr[TABLES.PatientTransfusionReaction.PostSpecimenClericalChecksOkIndicator] = true;
			dr[TABLES.PatientTransfusionReaction.PartialSaveId] = 1;
			dr[TABLES.PatientTransfusionReaction.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.PatientTransfusionReaction.RecordStatusCode] = "A";
			dr[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTransfusionReaction.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;

			dr[TABLES.PatientTransfusionReaction.PreSpecimenGuid] = preGuid;
			dr[TABLES.PatientTransfusionReaction.PostSpecimenGuid] = postGuid;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// spInsertPatientTreatment
		/// </summary>
		/// <param name="ptGuid"></param>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertPatientTreatmentSprocTable(Guid ptGuid, Guid patientGuid)
		{
			DataTable dt = new DataTable(TABLES.PatientTreatment.TableName);

			dt.Columns.Add(TABLES.PatientTreatment.PatientTreatmentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTreatment.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTreatment.PatientLocation, typeof(string));
			dt.Columns.Add(TABLES.PatientTreatment.PatientRoomBed, typeof(string));
			dt.Columns.Add(TABLES.PatientTreatment.PatientAdmittingDiagnosis, typeof(string));
			dt.Columns.Add(TABLES.PatientTreatment.InPatientIndicator, typeof(bool));

			dt.Columns.Add(TABLES.PatientTreatment.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientTreatment.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();

			dr[TABLES.PatientTreatment.PatientTreatmentGuid] = ptGuid;
			dr[TABLES.PatientTreatment.PatientGuid] = patientGuid;
			dr[TABLES.PatientTreatment.PatientLocation] = "Springfield Hospital";
			dr[TABLES.PatientTreatment.PatientRoomBed] = "4201974";
			dr[TABLES.PatientTreatment.PatientAdmittingDiagnosis] = "The patient is too scared..to scared to even wet himself.";
			dr[TABLES.PatientTreatment.InPatientIndicator] = (DateTime.Now.Minute < 30) ? true : false;
			dr[TABLES.PatientTreatment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTreatment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;

			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// spInsertProductShipper
		/// </summary>
		/// <param name="psGuid"></param>
		/// <param name="bpGuid"></param>
		/// <param name="lsGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertProductShipperSprocTable(Guid psGuid, Guid bpGuid, Guid lsGuid)
		{
			DataTable dt = new DataTable(TABLES.ProductShipper.TableName);

			dt.Columns.Add(TABLES.ProductShipper.ProductShipperGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ProductShipper.BloodProductGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ProductShipper.LocalSupplierGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ProductShipper.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.ProductShipper.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.ProductShipper.ProductCost, typeof(decimal));
			dt.Columns.Add(TABLES.ProductShipper.ReturnCreditPercentage, typeof(decimal));
			dt.Columns.Add(TABLES.ProductShipper.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.ProductShipper.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.ProductShipper.ProductShipperGuid] = psGuid;
			dr[TABLES.ProductShipper.BloodProductGuid] = bpGuid;
			dr[TABLES.ProductShipper.LocalSupplierGuid] = lsGuid;
			dr[TABLES.ProductShipper.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLES.ProductShipper.RecordStatusCode] = "A";
			dr[TABLES.ProductShipper.ProductCost] = decimal.One;
			dr[TABLES.ProductShipper.ReturnCreditPercentage] = decimal.One;
			dr[TABLES.ProductShipper.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.ProductShipper.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertRackLot 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertRackLotSprocTable(Guid reagentGuid, Guid rackGuid)
		{
			DataTable dt = new DataTable(TABLES.RackLot.TableName);

			dt.Columns.Add(TABLES.RackLot.RackLotGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackLot.RackGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackLot.LotUseDate, typeof(DateTime));
			dt.Columns.Add(TABLES.RackLot.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.RackLot.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.RackLot.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.RackLot.RackLotGuid] = Guid.NewGuid();
			dr[TABLES.RackLot.RackGuid] = rackGuid;
			dr[TABLES.RackLot.ReagentGuid] = reagentGuid;
			dr[TABLES.RackLot.LotUseDate] = DateTime.Now;
			dr[TABLES.RackLot.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.RackLot.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertRackTest 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertRackTestSprocTable(Guid rtGuid, Guid rackLotGuid)
		{
			DataTable dt = new DataTable(TABLES.RackTest.TableName);

			dt.Columns.Add(TABLES.RackTest.RackTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackTest.RackLotGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.RackTest.TestTechId, typeof(string));
			dt.Columns.Add(TABLES.RackTest.RackTestResult, typeof(string));
			dt.Columns.Add(TABLES.RackTest.RackTestResultTypeCode, typeof(string));
			dt.Columns.Add(TABLES.RackTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.RackTest.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.RackTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.RackTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.RackTest.RackTestGuid] = rtGuid;
			dr[TABLES.RackTest.RackLotGuid] = rackLotGuid;
			dr[TABLES.RackTest.TestDate] = DateTime.Now;
			dr[TABLES.RackTest.TestTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.RackTest.RackTestResult] = "X";
			dr[TABLES.RackTest.RackTestResultTypeCode] = ARTIFICIAL.AHG;
			dr[TABLES.RackTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.RackTest.RecordStatusCode] ="A";
			dr[TABLES.RackTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.RackTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// spInsertReagent
		/// </summary>
		/// <param name="reagentGuid"></param>
		/// <param name="reagentTypeId"></param>
		/// <returns></returns>
		public static DataTable GetInsertReagentSprocTable(Guid reagentGuid, int reagentTypeId)
		{

			DataTable dt = new DataTable(TABLES.Reagent.TableName);

			dt.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Reagent.ReagentTypeId, typeof(int));
			dt.Columns.Add(TABLES.Reagent.ReagentName, typeof(string));
			dt.Columns.Add(TABLES.Reagent.ReagentManufacturerName, typeof(string));
			dt.Columns.Add(TABLES.Reagent.ReceiptDate, typeof(DateTime));
			dt.Columns.Add(TABLES.Reagent.ReceiptTechId, typeof(string));
			dt.Columns.Add(TABLES.Reagent.InvoiceNumber, typeof(string));
			dt.Columns.Add(TABLES.Reagent.LotNumber, typeof(string));
			dt.Columns.Add(TABLES.Reagent.LotExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLES.Reagent.NumberVialsReceived, typeof(int));
			dt.Columns.Add(TABLES.Reagent.NumberVialsAvailable, typeof(int));
			dt.Columns.Add(TABLES.Reagent.Comments, typeof(string));
			dt.Columns.Add(TABLES.Reagent.InspectionIndicator, typeof(bool));
			dt.Columns.Add(TABLES.Reagent.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.Reagent.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.Reagent.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.Reagent.ReagentGuid] = reagentGuid;
			dr[TABLES.Reagent.ReagentTypeId] = reagentTypeId;
			dr[TABLES.Reagent.ReagentName] = "Blernsball";
			dr[TABLES.Reagent.ReagentManufacturerName] = "Planet Express Inc";
			dr[TABLES.Reagent.ReceiptDate] = DateTime.Now.AddDays(-7);
			dr[TABLES.Reagent.ReceiptTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.Reagent.InvoiceNumber] = "UT" + new Random().Next(99999).ToString();
			dr[TABLES.Reagent.LotNumber] = "UT" + new Random().Next(999999).ToString();
			dr[TABLES.Reagent.LotExpirationDate] = DateTime.Now.AddDays(7);
			dr[TABLES.Reagent.NumberVialsReceived] = new Random().Next(50,999);
			dr[TABLES.Reagent.NumberVialsAvailable] = new Random().Next(1,50);
			dr[TABLES.Reagent.Comments] = DateTime.Now.ToString();
			dr[TABLES.Reagent.InspectionIndicator] = true;
			dr[TABLES.Reagent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.Reagent.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
			dr[TABLES.Reagent.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertReagentChange
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertReagentChangeSprocTable(Guid reagentGuid)
		{
			DataTable dt = new DataTable(TABLES.ReagentChange.TableName);

			dt.Columns.Add(TABLES.ReagentChange.ReagentChangeGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ReagentChange.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ReagentChange.ReagentChangeDetailCode, typeof(string));
			dt.Columns.Add(TABLES.ReagentChange.Comments, typeof(string));
			dt.Columns.Add(TABLES.ReagentChange.LastUpdateDate, typeof(string));
			dt.Columns.Add(TABLES.ReagentChange.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.ReagentChange.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.ReagentChange.ReagentChangeGuid] = Guid.NewGuid();
			dr[TABLES.ReagentChange.ReagentGuid] = reagentGuid;
			dr[TABLES.ReagentChange.ReagentChangeDetailCode] = "B";
			dr[TABLES.ReagentChange.Comments] = DateTime.Now.ToString();
			dr[TABLES.ReagentChange.LastUpdateDate] = DateTime.Now;
			dr[TABLES.ReagentChange.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.ReagentChange.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertShipment
		/// </summary>
		/// <param name="shipmentGuid"></param>
		/// <param name="localSupplierGuid"></param>
		/// <param name="productShipperGuid"></param>
		/// <returns></returns>
		public static DataTable GetInsertShipmentSprocTable(Guid shipmentGuid, Guid localSupplierGuid, Guid productShipperGuid)
		{
			DataTable dt = new DataTable(TABLES.Shipment.TableName);

			dt.Columns.Add(TABLES.Shipment.ShipmentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Shipment.LocalSupplierGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Shipment.ProductShipperGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Shipment.ShipmentDirection, typeof(bool));			//BIT
			dt.Columns.Add(TABLES.Shipment.ShipmentDate, typeof(DateTime));			//NULL
			dt.Columns.Add(TABLES.Shipment.InvoiceNumber, typeof(string));				//VARCHAR(14)
			dt.Columns.Add(TABLES.Shipment.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.Shipment.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.Shipment.LastUpdateFunctionId, typeof(int));
		

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.Shipment.ShipmentGuid] = shipmentGuid;
			dr[TABLES.Shipment.LocalSupplierGuid] = localSupplierGuid;
			dr[TABLES.Shipment.ProductShipperGuid] = productShipperGuid;
			dr[TABLES.Shipment.ShipmentDirection] = true;
			dr[TABLES.Shipment.ShipmentDate] = DateTime.Now;
			dr[TABLES.Shipment.InvoiceNumber] = new Random().Next(11111,99999).ToString() + new Random().Next(1,99999).ToString();
			dr[TABLES.Shipment.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.Shipment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.Shipment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);

		}

		/// <summary>
		/// Creates a DataTable for spInsertSpecimenTest
		/// </summary>
		/// <param name="stGuid"></param>
		/// <param name="otGuid"></param>
		/// <param name="psGuid"></param>
		/// <param name="bloodTestTypeId"></param>
		/// <returns></returns>
		public static DataTable GetInsertSpecimenTestSprocTable(Guid stGuid, Guid otGuid, Guid psGuid, int bloodTestTypeId)
		{
			DataTable dt = new DataTable(TABLES.SpecimenTest.TableName);

			dt.Columns.Add(TABLES.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTest.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTest.TestTechId, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.BloodTestTypeId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.SpecimenTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateUser, typeof(string));

			DataRow dr = dt.NewRow();

			dr[TABLES.SpecimenTest.SpecimenTestGuid] = stGuid;
			dr[TABLES.SpecimenTest.OrderedTestGuid] = otGuid;
			dr[TABLES.SpecimenTest.PatientSpecimenGuid] = psGuid;
			dr[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTest.BloodTestTypeId] = bloodTestTypeId;
			dr[TABLES.SpecimenTest.TestDate] = DateTime.Now;
			dr[TABLES.SpecimenTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.SpecimenTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;

			dt.Rows.Add(dr);
			
			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertSpecimenTestThreshold
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertSpecimenTestThresholdSprocTable(Guid sttGuid, string labTestId)
		{
			DataTable dt = new DataTable(TABLES.SpecimenTestThreshold.TableName);

			dt.Columns.Add(TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.LabTestId, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.ComponentClassId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.VistaLaboratoryTestName, typeof(string));		//50
			dt.Columns.Add(TABLES.SpecimenTestThreshold.SpecimenTypeCode, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.ReportTypeId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTestThreshold.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.SpecimenTestThreshold.SpecimenTestThresholdGuid] = sttGuid;
			dr[TABLES.SpecimenTestThreshold.LabTestId] = labTestId;
			dr[TABLES.SpecimenTestThreshold.ComponentClassId] = 1;
			dr[TABLES.SpecimenTestThreshold.VistaLaboratoryTestName] = new Random().Next(9999,999999).ToString();
			dr[TABLES.SpecimenTestThreshold.SpecimenTypeCode] = "S";
			dr[TABLES.SpecimenTestThreshold.ReportTypeId] = new Random().Next(7,9);
			dr[TABLES.SpecimenTestThreshold.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.SpecimenTestThreshold.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString();
			dr[TABLES.SpecimenTestThreshold.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTestThreshold.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInsertSupply
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertSupplySprocTable(Guid supplyGuid)
		{
			DataTable dt = new DataTable(TABLES.Supply.TableName);

			dt.Columns.Add(TABLES.Supply.SupplyGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Supply.SupplyTypeId, typeof(int));
			dt.Columns.Add(TABLES.Supply.ReceiptDate, typeof(DateTime));
			dt.Columns.Add(TABLES.Supply.ReceiptTechId, typeof(string));
			dt.Columns.Add(TABLES.Supply.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.Supply.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.Supply.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.Supply.AvailableQuantity, typeof(Int16));
			dt.Columns.Add(TABLES.Supply.SatisfactoryIndicator, typeof(bool));
			dt.Columns.Add(TABLES.Supply.LotQuantity, typeof(Int16));
			dt.Columns.Add(TABLES.Supply.LotExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLES.Supply.SupplyName, typeof(string));
			dt.Columns.Add(TABLES.Supply.ManufacturerName, typeof(string));
			dt.Columns.Add(TABLES.Supply.InvoiceNumber, typeof(string));
			dt.Columns.Add(TABLES.Supply.LotNumber, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.Supply.SupplyGuid] = supplyGuid;
			dr[TABLES.Supply.SupplyTypeId] = 1;
			dr[TABLES.Supply.ReceiptDate] = DateTime.Now;
			dr[TABLES.Supply.ReceiptTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.Supply.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.Supply.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.Supply.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.Supply.AvailableQuantity] = 1;
			dr[TABLES.Supply.SatisfactoryIndicator] = true;
			dr[TABLES.Supply.LotQuantity] = 1;
			dr[TABLES.Supply.LotExpirationDate] = DateTime.Now.AddDays(30);
			dr[TABLES.Supply.SupplyName] = "Test Supply";
			dr[TABLES.Supply.ManufacturerName] = "Test Manufacturer";
			dr[TABLES.Supply.InvoiceNumber] = new Random().Next(1111,99999).ToString();
			dr[TABLES.Supply.LotNumber] = DateTime.Now.ToString("yymmddhhmmss");
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spInsertTransfusionRequirements
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertTransfusionRequirements(Guid ptrGuid, Guid patientGuid)
		{
			DataTable dt = new DataTable(TABLES.PatientTransfusionRequirement.TableName);

			dt.Columns.Add(TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.TransfusionRequirementText, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.CreateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.CreateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnit.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionRequirement.LastUpdateUser, typeof(string));
			
			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = ptrGuid;
			dr[TABLES.PatientTransfusionRequirement.PatientGuid] = patientGuid;
			dr[TABLES.PatientTransfusionRequirement.TransfusionRequirementText] = DateTime.Now.ToString();
			dr[TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = "AS";
			dr[TABLES.PatientTransfusionRequirement.CreateDate] = DateTime.Now;
			dr[TABLES.PatientTransfusionRequirement.CreateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTransfusionRequirement.RecordStatusCode] = "A";
			dr[TABLES.PatientTransfusionRequirement.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.BloodUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.PatientTransfusionRequirement.LastUpdateUser] = Common.LogonUser.LogonUserName;

			dt.Rows.Add(dr);
			return(dt);
	

		}

		/// <summary>
		/// Creates a DataTable for spInsertWorkloadEvents
		/// </summary>
		/// <returns></returns>
		public static DataTable GetInsertWorkloadEventsSprocTable()
		{
			DataTable dt = new DataTable(TABLES.WorkloadEvent.TableName);

			dt.Columns.Add(TABLES.WorkloadEvent.WorkloadEventGuid, typeof(Guid));
			dt.Columns.Add(TABLES.WorkloadEvent.WorkloadEventDate, typeof(DateTime));
			dt.Columns.Add(TABLES.WorkloadEvent.WorkloadProcessGuid, typeof(Guid));
			dt.Columns.Add(TABLES.WorkloadEvent.WorkloadEventStatusCode, typeof(string));
			dt.Columns.Add(TABLES.WorkloadEvent.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.WorkloadEvent.RecordSentIndicator, typeof(bool));
			dt.Columns.Add(TABLES.WorkloadEvent.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.WorkloadEvent.VistaTechId, typeof(string));
			dt.Columns.Add(TABLES.WorkloadEvent.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.WorkloadEvent.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.WorkloadEvent.WorkloadEventGuid] = Guid.NewGuid();
			dr[TABLES.WorkloadEvent.WorkloadEventDate] = DateTime.Now;
			dr[TABLES.WorkloadEvent.WorkloadProcessGuid] = Guid.NewGuid();
			dr[TABLES.WorkloadEvent.WorkloadEventStatusCode] = "S";
			dr[TABLES.WorkloadEvent.RecordStatusCode] = "A";
			dr[TABLES.WorkloadEvent.RecordSentIndicator] = true;
			dr[TABLES.WorkloadEvent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.WorkloadEvent.VistaTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.WorkloadEvent.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.WorkloadEvent.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// spInvalidateTransfusionReactionWorkup
		/// </summary>
		/// <param name="ptrGuid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetInvalidateTransfusionReactionWorkupSprocTable(Guid ptrGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.PatientTransfusionReaction.TableName);

			dt.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte[]));

			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = ptrGuid;
			dr[TABLES.PatientTransfusionReaction.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTransfusionReaction.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.PatientTransfusionReaction.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLES.PatientTransfusionReaction.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spConfirmOutgoingShipment
		/// </summary>
		/// <remarks>
		///		Created on 12/3/2004
		///		Created By Rob Heiberger
		/// </remarks>
		/// <param name="rowVersion">row version of the item being updated</param>
		/// <param name="shipmentDate">date of shipment</param>
		/// <param name="shipmentGuid">shipment id</param>
		/// <returns>Data Table</returns>
		public static DataTable GetConfirmOutgoingShipmentSprocTable(DateTime shipmentDate, Guid shipmentGuid, byte[] rowVersion)
		{
			DataTable dtShipment = new DataTable(TABLES.Shipment.TableName);
			dtShipment.Columns.Add(TABLES.Shipment.ShipmentGuid, typeof(Guid));
			dtShipment.Columns.Add(TABLES.Shipment.ShipmentDate, typeof(DateTime));
			dtShipment.Columns.Add(TABLES.Shipment.LastUpdateUser, typeof(System.String));
			dtShipment.Columns.Add(TABLES.Shipment.LastUpdateFunctionId, typeof(System.Int32));
			dtShipment.Columns.Add(TABLES.BloodUnitStatus.RowVersion, typeof(byte[]));
			
			DataRow unitRow = dtShipment.NewRow();
			unitRow[TABLES.Shipment.ShipmentGuid] = shipmentGuid;
			unitRow[TABLES.Shipment.ShipmentDate] = shipmentDate;
			unitRow[TABLES.Shipment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			unitRow[TABLES.Shipment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			unitRow[TABLES.Shipment.RowVersion] = rowVersion;
			dtShipment.Rows.Add(unitRow);

			return dtShipment;
		}


		/// <summary>
		/// GetFinalizePatientTransfusionReaction
		/// </summary>
		/// <param name="ptrGuid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetFinalizePatientTransfusionReaction(Guid ptrGuid, byte[] rowVersion)
		{

			DataTable dt = new DataTable(TABLES.PatientTransfusionReaction.TableName);

			dt.Columns.Add(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.PartialSaveId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.MedicalDirectorName, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.PatientTransfusionReaction.DivisionCode, typeof(string));
			
			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid] = ptrGuid;
			dr[TABLES.PatientTransfusionReaction.PartialSaveId] = 1;
			dr[TABLES.PatientTransfusionReaction.MedicalDirectorName] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTransfusionReaction.TransfusionReactionTypeCode] = "A";
			dr[TABLES.PatientTransfusionReaction.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.PatientTransfusionReaction.RowVersion] = rowVersion;
			dr[TABLES.PatientTransfusionReaction.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spConfirmOutgoingShipment
		/// </summary>
		/// <remarks>
		///		Created on 12/3/2004
		///		Created By Rob Heiberger
		/// </remarks>
		/// <param name="antiseraWorklistTypingGuid">antiseraWorklistTypingGuid</param>
		/// <param name="bloodUnitGuid">bloodUnitGuid</param>
		/// <param name="comments">comments</param>
		/// <param name="orderableTestId">orderableTestId</param>
		/// <param name="rowVersion">rowVersion</param>
		/// <returns>Data Table</returns>
		public static DataTable GetInactivateAntigenTypingTestsSprocTable(Guid bloodUnitGuid, Guid antiseraWorklistTypingGuid, int orderableTestId, string comments, byte[] rowVersion)
		{
			DataTable dtAntigenTypingTests = new DataTable(TABLES.BloodUnitTest.TableName); 
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtAntigenTypingTests.Columns.Add(TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid, typeof(Guid));
			dtAntigenTypingTests.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnitMedia.Comments, typeof(string));
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnitTest.InactivateDate, typeof(DateTime));
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnitTest.InactivateUser, typeof(string));
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));
			dtAntigenTypingTests.Columns.Add(TABLES.BloodUnitTest.RowVersion, typeof(byte[]));

			DataRow dtRow = dtAntigenTypingTests.NewRow();
			dtRow[TABLES.BloodUnit.BloodUnitGuid] = bloodUnitGuid;
			dtRow[TABLES.AntiseraWorklistTyping.AntiseraWorklistTypingGuid] = antiseraWorklistTypingGuid;
			dtRow[TABLES.OrderableTest.OrderableTestId] = orderableTestId;
			dtRow[TABLES.BloodUnitMedia.Comments] = comments;
			dtRow[TABLES.BloodUnitTest.InactivateDate] = gov.va.med.vbecs.DAL.VbecsDateTime.GetDivisionCurrentDateTime();
			dtRow[TABLES.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
			dtRow[TABLES.BloodUnitTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dtRow[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtRow[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dtRow[TABLES.BloodUnitTest.RowVersion] = rowVersion;
			dtAntigenTypingTests.Rows.Add(dtRow);

			return dtAntigenTypingTests;
		}


		/// <summary>
		/// Creates a DataTable for spHL7InsertPatientChange
		/// </summary>
		/// <returns></returns>
		public static DataTable GetHL7InsertPatientChange(Guid pcGuid, Guid fromPatientGuid, Guid toPatientGuid )
		{
			DataTable dt = new DataTable(TABLES.PatientChange.TableName);
			
			DataRow drFrom = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient WHERE PatientGuid = '" + fromPatientGuid.ToString() + "'");
			DataRow drTo = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient WHERE PatientGuid = '" + toPatientGuid.ToString() + "'");

			dt.Columns.Add(TABLES.PatientChange.PatientChangeGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientChange.FromPatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientChange.FromPatientSsn, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.FromPatientLastName, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.FromPatientMIddleName, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.FromPatientFirstName, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.FromPatientDob, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientChange.FromPatientSexCode, typeof(string));


			dt.Columns.Add(TABLES.PatientChange.ToPatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientChange.ToPatientSsn, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.ToPatientLastName, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.ToPatientMIddleName, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.ToPatientFirstName, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.ToPatientDob, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientChange.ToPatientSexCode, typeof(string));

			dt.Columns.Add(TABLES.PatientChange.MergeFromVistaPatientId, typeof(long));
			dt.Columns.Add(TABLES.PatientChange.MergeToVistaPatientId, typeof(long));
			dt.Columns.Add(TABLES.PatientChange.PatientChangeStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.LastUpdateFunctionId, typeof(int));
			
			//Create a dummy row for the table
			DataRow dr = dt.NewRow();

			dr[TABLES.PatientChange.PatientChangeGuid] = pcGuid;
			dr[TABLES.PatientChange.FromPatientGuid] = fromPatientGuid;
			dr[TABLES.PatientChange.FromPatientSsn] = drFrom[TABLES.Patient.PatientSsn].ToString();
			dr[TABLES.PatientChange.FromPatientLastName] = drFrom[TABLES.Patient.PatientLastName].ToString();
			dr[TABLES.PatientChange.FromPatientFirstName] = drFrom[TABLES.Patient.PatientFirstName].ToString();
			dr[TABLES.PatientChange.FromPatientDob] = (DateTime)drFrom[TABLES.Patient.PatientDob];
			dr[TABLES.PatientChange.FromPatientSexCode] = drFrom[TABLES.Patient.PatientSexCode].ToString();

			dr[TABLES.PatientChange.ToPatientGuid] = toPatientGuid;
			dr[TABLES.PatientChange.ToPatientSsn] = drTo[TABLES.Patient.PatientSsn].ToString();
			dr[TABLES.PatientChange.ToPatientLastName] = drTo[TABLES.Patient.PatientLastName].ToString();
			dr[TABLES.PatientChange.ToPatientFirstName] = drTo[TABLES.Patient.PatientFirstName].ToString();
			dr[TABLES.PatientChange.ToPatientDob] = (DateTime)drTo[TABLES.Patient.PatientDob];
			dr[TABLES.PatientChange.ToPatientSexCode] = drTo[TABLES.Patient.PatientSexCode].ToString();

			dr[TABLES.PatientChange.MergeFromVistaPatientId] = System.Convert.ToInt64(drFrom[TABLES.Patient.VistaPatientId]);
			dr[TABLES.PatientChange.MergeToVistaPatientId] = System.Convert.ToInt64(drTo[TABLES.Patient.VistaPatientId]);

			dr[TABLES.PatientChange.PatientChangeStatusCode] = "S";
			dr[TABLES.PatientChange.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientChange.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;

			dt.Rows.Add(dr);
			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spHL7UpdateOrderedComponent
		/// </summary>
		/// <returns></returns>
		public static DataTable GetHL7UpdateOrderedComponent(Guid ocGuid, Guid poGuid, bool createOrderStatus)
		{
			DataTable dt = new DataTable(TABLES.OrderedComponent.TableName);

			dt.Columns.Add(TABLES.OrderedComponent.OrderedComponentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedComponent.PatientOrderGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedComponent.ComponentClassId, typeof(int));
			dt.Columns.Add(TABLES.OrderedComponent.CprsOrderNumber, typeof(string));		//20
			dt.Columns.Add(TABLES.OrderedComponent.VbecsOrderNumber, typeof(int));			
			dt.Columns.Add(TABLES.OrderedComponent.RequiredUnitQuantity, typeof(decimal));	//18,0
			dt.Columns.Add(TABLES.OrderedComponent.SpecimenStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.PreOpIndicator, typeof(bool));
			dt.Columns.Add(TABLES.OrderedComponent.OrderUrgencyCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.LabOrderNumber, typeof(string));		//20
			dt.Columns.Add(TABLES.OrderedComponent.LabTestId, typeof(string));		//20
			dt.Columns.Add(TABLES.OrderedComponent.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.LastUpdateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedComponent.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedComponent.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.OrderStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.RequiredDatetime, typeof(DateTime));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedComponent.OrderedComponentGuid] = ocGuid;
			dr[TABLES.OrderedComponent.PatientOrderGuid] = poGuid;
			dr[TABLES.OrderedComponent.ComponentClassId] = 1;
			// ********************************************************************************************************************************************
			// CPRS Order Number, although a VARCHAR in VBECS, cannot be non-numeric.  If it is some of the old HL7 code will blow up.
            dr[TABLES.OrderedComponent.CprsOrderNumber] = SprocHelper.GetNewCprsOrderNumber();
			// ********************************************************************************************************************************************
			dr[TABLES.OrderedComponent.VbecsOrderNumber] = new Random().Next(99999,9999999);
			dr[TABLES.OrderedComponent.RequiredUnitQuantity] = (decimal)99;
			dr[TABLES.OrderedComponent.SpecimenStatusCode] = "A";
			dr[TABLES.OrderedComponent.PreOpIndicator] = true;
			dr[TABLES.OrderedComponent.OrderUrgencyCode] = "P";
			dr[TABLES.OrderedComponent.LabOrderNumber] = dr[TABLES.OrderedComponent.CprsOrderNumber].ToString();
			dr[TABLES.OrderedComponent.LabTestId] = "53311";
			dr[TABLES.OrderedComponent.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedComponent.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedComponent.LastUpdateDate] = DateTime.Now;
			dr[TABLES.OrderedComponent.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.OrderedComponent.RequiredDatetime] = DateTime.Now.AddDays(-1);

			if (createOrderStatus)
			{
				dr[TABLES.OrderedComponent.OrderStatusCode] = "A";
			}

			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spHL7UpdateOrderedTest
		/// </summary>
		/// <returns></returns>
		public static DataTable GetHL7UpdateOrderedTest(Guid otGuid, Guid poGuid, bool isPending)
		{
			DataTable dt = new DataTable(TABLES.OrderedTest.TableName);

			dt.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.PatientOrderGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.CprsOrderNumber, typeof(string));		//20
			dt.Columns.Add(TABLES.OrderedTest.VbecsOrderNumber, typeof(int));			
			dt.Columns.Add(TABLES.OrderedTest.SpecimenRequiredIndicator, typeof(bool));
			dt.Columns.Add(TABLES.OrderedTest.OrderStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.OrderUrgencyCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.OrderedTestComments, typeof(string));		//510
			dt.Columns.Add(TABLES.OrderedTest.RequiredResultsDate, typeof(DateTime));		
			dt.Columns.Add(TABLES.OrderedTest.OrderableTestId, typeof(int));		
			dt.Columns.Add(TABLES.OrderedTest.TaskStatusCode, typeof(string));		
			dt.Columns.Add(TABLES.OrderedTest.LabOrderNumber, typeof(string));		
			dt.Columns.Add(TABLES.OrderedTest.LabTestId, typeof(string));
		
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedTest.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedTest.OrderedTestGuid] = otGuid;
			dr[TABLES.OrderedTest.PatientOrderGuid] = poGuid;
			// ********************************************************************************************************************************************
			// CPRS Order Number, although a VARCHAR in VBECS, cannot be non-numeric.  If it is some of the old HL7 code will blow up.
            dr[TABLES.OrderedTest.CprsOrderNumber] = SprocHelper.GetNewCprsOrderNumber();
			// ********************************************************************************************************************************************
			dr[TABLES.OrderedTest.VbecsOrderNumber] = new Random().Next(99999,9999999);
			dr[TABLES.OrderedTest.SpecimenRequiredIndicator] = DBNull.Value;
			dr[TABLES.OrderedTest.OrderStatusCode] = isPending ? "P" : "A";
			dr[TABLES.OrderedTest.OrderUrgencyCode] = "R";
			dr[TABLES.OrderedTest.OrderedTestComments] = "SprocHelper.GetHL7UpdateOrderedTest()";
			dr[TABLES.OrderedTest.RequiredResultsDate] = DateTime.Now;
			dr[TABLES.OrderedTest.OrderableTestId] = 7;
			dr[TABLES.OrderedTest.TaskStatusCode] = DBNull.Value;
			dr[TABLES.OrderedTest.LabOrderNumber] = dr[TABLES.OrderedComponent.CprsOrderNumber].ToString();
			dr[TABLES.OrderedTest.LabTestId] = "53311";

			dr[TABLES.OrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedTest.LastUpdateDate] = DateTime.Now;
			dr[TABLES.OrderedTest.DivisionCode] = UnitTestConfig.TestDivisionCode;

			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spHL7UpdatePatientTest
		/// </summary>
		/// <returns></returns>
		public static DataTable GetHL7UpdatePatientTest(Guid patientGuid, Guid patientOrderGuid, string labTestId, int orderableTestId) 
		{
			DataTable dt = new DataTable(TABLES.PatientTest.TableName);

			dt.Columns.Add(TABLES.PatientTest.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTest.PatientOrderGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTest.OrderableTestId, typeof(int));
			dt.Columns.Add(TABLES.PatientTest.LabTestId, typeof(string));				//15
			dt.Columns.Add(TABLES.PatientTest.TestDate, typeof(DateTime));			
			dt.Columns.Add(TABLES.PatientTest.TestResult, typeof(string));				//60
			dt.Columns.Add(TABLES.PatientTest.ResultDateTime, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTest.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientTest.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTest.PatientGuid] = patientGuid;
			dr[TABLES.PatientTest.PatientOrderGuid] = patientOrderGuid;
			dr[TABLES.PatientTest.OrderableTestId] = orderableTestId;
			dr[TABLES.PatientTest.LabTestId] = labTestId;
			dr[TABLES.PatientTest.TestDate] = DateTime.Now;
			dr[TABLES.PatientTest.TestResult] = DateTime.Now.ToString();
			dr[TABLES.PatientTest.ResultDateTime] = DateTime.Now;
			dr[TABLES.PatientTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.PatientTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString();
			dr[TABLES.PatientTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;

			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spInactivateABORHConfirmationTests
		/// </summary>
		/// <remarks>
		///		Created on 12/6/2004
		///		Created By Rob Heiberger
		/// </remarks>
		/// <param name="antiseraWorklistTypingGuid">worklistGuid</param>
		/// <param name="bloodUnitGuid">bloodUnitGuid</param>
		/// <param name="comments">comments</param>
		/// <param name="rowVersion">rowVersion</param>
		/// <returns>Data Table</returns>
		public static DataTable GetInactivateABORHConfirmationTestsSprocTable(Guid bloodUnitGuid, Guid worklistGuid, string comments, byte[] rowVersion)
		{
			DataTable dtTests = new DataTable(TABLES.BloodUnitTest.TableName);
			dtTests.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(Guid));
			dtTests.Columns.Add(TABLES.ConfirmationWorklistUnit.ConfirmationWorklistUnitGuid, typeof(Guid));
			dtTests.Columns.Add(TABLES.BloodUnitMedia.Comments, typeof(string));
			dtTests.Columns.Add(TABLES.BloodUnitTest.InactivateDate, typeof(DateTime));
			dtTests.Columns.Add(TABLES.BloodUnitTest.InactivateUser, typeof(string));
			dtTests.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			dtTests.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dtTests.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));
			dtTests.Columns.Add(TABLES.BloodUnitTest.RowVersion, typeof(byte[]));

			DataRow dtRow = dtTests.NewRow();
			dtRow[TABLES.BloodUnit.BloodUnitGuid] = bloodUnitGuid;
			dtRow[TABLES.ConfirmationWorklistUnit.ConfirmationWorklistUnitGuid] = worklistGuid;
			dtRow[TABLES.BloodUnitMedia.Comments] = comments;
			dtRow[TABLES.BloodUnitTest.InactivateDate] = gov.va.med.vbecs.DAL.VbecsDateTime.GetDivisionCurrentDateTime();
			dtRow[TABLES.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
			dtRow[TABLES.BloodUnitTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dtRow[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dtRow[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dtRow[TABLES.BloodUnitTest.RowVersion] = rowVersion;
			dtTests.Rows.Add(dtRow);

			return dtTests;
		}

		/// <summary>
		/// Returns table for spInactivateOrderedTestResults
		/// </summary>
		/// <param name="otGuid"></param>
		/// <param name="otId"></param>
		/// <param name="stRowVersion"></param>
		/// <param name="aotRowVersion"></param>
		/// <param name="rlRowVersion"></param>
		/// <param name="rtRowVersion"></param>
		/// <param name="otRowVersion"></param>
		/// <returns></returns>
		public static DataTable GetInactivateOrderedTestResultsSprocTable(Guid otGuid, int otId, byte[] stRowVersion, byte[] aotRowVersion, byte[] rlRowVersion, byte[] rtRowVersion, byte[] otRowVersion)
		{
			DataTable dt = new DataTable(TABLES.OrderedTest.TableName);

			dt.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTest.InactivateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.SpecimenTest.InactivateUser, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.OrderableTest.OrderableTestId, typeof(int));
			dt.Columns.Add("SpecimenTestRowVersion", typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.AntiseraOrderedTestRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.RackLotRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.RackTestRowVersion, typeof(byte[]));
			dt.Columns.Add(ARTIFICIAL.OrderedTestRowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();

			dr[TABLES.OrderedTest.OrderedTestGuid] = otGuid;
			dr[TABLES.SpecimenTest.InactivateDate] = DateTime.Now;
			dr[TABLES.SpecimenTest.InactivateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.OrderableTest.OrderableTestId] = otId;
			dr[ARTIFICIAL.SpecimenTestRowVersion] = stRowVersion;
			dr[ARTIFICIAL.AntiseraOrderedTestRowVersion] = aotRowVersion;
			dr[ARTIFICIAL.RackLotRowVersion] = rlRowVersion;
			dr[ARTIFICIAL.RackTestRowVersion] = rtRowVersion;
			dr[ARTIFICIAL.OrderedTestRowVersion] = otRowVersion;
			dr[TABLES.SpecimenTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spReleaseOrderedUnits
		/// </summary>
		/// <returns></returns>
		public static DataTable GetReleaseOrderedUnitsSprocTable(Guid orderedUnitGuid, byte[] ouRowVersion)
		{
			DataTable dt = new DataTable(TABLES.OrderedUnit.TableName);

			dt.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.ReleaseTechId, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.ReleaseDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedUnit.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedUnit.OrderedUnitGuid] = orderedUnitGuid;
			dr[TABLES.OrderedUnit.ReleaseTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.ReleaseDate] = DateTime.Now;			
			dr[TABLES.OrderedUnit.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedUnit.RowVersion] = ouRowVersion;
			dr[TABLES.OrderedUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spReleaseOrderedUnitsByBloodUnit
		/// </summary>
		/// <returns></returns>
		public static DataTable GetReleaseOrderedUnitsByBloodUnitSprocTable(Guid buGuid, byte[] ouRowVersion)
		{
			DataTable dt = new DataTable(TABLES.OrderedUnit.TableName);

			dt.Columns.Add(TABLES.OrderedUnit.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.ReleaseTechId, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.ReleaseDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedUnit.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedUnit.BloodUnitGuid] = buGuid;
			dr[TABLES.OrderedUnit.ReleaseTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.ReleaseDate] = DateTime.Now;			
			dr[TABLES.OrderedUnit.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedUnit.RowVersion] = ouRowVersion;
			dr[TABLES.OrderedUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Gets the DataTable for spUpdateAddress
		/// </summary>
		/// <param name="addressGuid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetUpdateAddressSprocTable(Guid addressGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.Address.TableName);

			dt.Columns.Add(TABLES.Address.AddressGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Address.AddressLine1, typeof(string));
			dt.Columns.Add(TABLES.Address.AddressCity, typeof(string));
			dt.Columns.Add(TABLES.Address.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(ARTIFICIAL.AddressRowVersion, typeof(byte[]));

			DataRow dr = dt.NewRow();
			dr[TABLES.Address.AddressGuid] = addressGuid;
			dr[TABLES.Address.AddressLine1] = "742 Evergreen Terrace";
			dr[TABLES.Address.AddressCity] = "Springfield";
			dr[TABLES.Address.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[ARTIFICIAL.AddressRowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateBloodUnitModificationStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateBloodUnitModificationStatusSprocTable(Guid modificationGuid, string recStatusCode, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitModification.TableName);

			dt.Columns.Add(TABLES.BloodUnitModification.BloodUnitModificationGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitModification.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitModification.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.BloodUnitModification.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();

			dr[TABLES.BloodUnitModification.BloodUnitModificationGuid] = modificationGuid;
			dr[TABLES.BloodUnitModification.RecordStatusCode] = recStatusCode;
			dr[TABLES.BloodUnitModification.RowVersion] = rowVersion;
			dr[TABLES.BloodUnitModification.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;

			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateBloodUnitStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateBloodUnitStatusSprocTable(Guid busGuid, byte[] rowVersion, bool testingLimitIndicator)
		{
			DataTable dt = DAL.BloodUnitStatus.GetEmptyBloodUnitStatusTableSchema(true);

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitStatus.BloodUnitStatusGuid] = busGuid;
			dr[TABLES.BloodUnitStatus.BiohazardousWarningIndicator] = false;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = false;
			dr[TABLES.BloodUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.BloodUnitStatus.UnitStatusDate] = DateTime.Now;
			dr[TABLES.BloodUnitStatus.PresumedTransfusedIndicator] = false;
			dr[TABLES.BloodUnitStatus.EmergencyIssueIndicator] = false;
			dr[TABLES.BloodUnitStatus.UnitStatusComments] = DateTime.Now.ToString();
			dr[TABLES.BloodUnitStatus.TestingLimitIndicator] = false;
			dr[TABLES.BloodUnitStatus.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(Common.Utility.AppendLastUpdateInformation(dt, Common.UpdateFunction.UnitTests));
		}


		/// <summary>
		/// Creates a DataTable for spUpdateBloodUnitTestRecordStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateBloodUnitTestRecordStatusSprocTable(Guid butGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitTest.TableName);

			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.TestComments, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnitTest.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			
			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = butGuid;
			dr[TABLES.BloodUnitTest.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive);
			dr[TABLES.BloodUnitTest.TestComments] = "UT - " + DateTime.Now.ToString();
			dr[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.BloodUnitTest.RowVersion] = rowVersion;
			dr[TABLES.BloodUnitTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateBloodUnitTestResult
		/// </summary>
		/// <param name="butGuid"></param>
		/// <returns></returns>
		public static DataTable GetUpdateBloodUnitTestResultSprocTable(Guid butGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitTest.TableName);

			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.TestResultId, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnitTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.BloodUnitTest.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.BloodUnitTest.TestTechId, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.EntryTechId, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.DivisionCode, typeof(string));
			
			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = butGuid;
			dr[TABLES.BloodUnitTest.TestResultId] = "X";
			dr[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.BloodUnitTest.TestDate] = DateTime.Now;
			dr[TABLES.BloodUnitTest.RowVersion] = rowVersion;
			dr[TABLES.BloodUnitTest.TestTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.EntryTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.DivisionCode] = UnitTestConfig.TestDivisionCode;

			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spUpdateCannedComment
		/// </summary>
		/// <param name="commentGuid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetUpdateCannedCommentSprocTable(Guid commentGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.CannedComment.TableName);

			dt.Columns.Add(TABLES.CannedComment.CannedCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.CannedComment.SortColumn, typeof(int));
			dt.Columns.Add(TABLES.CannedComment.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.CannedComment.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.CannedComment.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.CannedComment.LastUpdateFunctionId, typeof(int));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.CannedComment.CannedCommentGuid] = commentGuid;
			dr[TABLES.CannedComment.SortColumn] = 44;
			dr[TABLES.CannedComment.RowVersion] = rowVersion;
			dr[TABLES.CannedComment.RecordStatusCode] = "A";
			dr[TABLES.CannedComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.CannedComment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateCrossmatchTestStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateCrossmatchTestStatusSprocTable()
		{
			DataTable dt = new DataTable(TABLES.BloodUnitTest.TableName);

			dt.Columns.Add(TABLES.BloodUnitTest.BloodUnitTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitTest.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.InactivateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.BloodUnitTest.InactivateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.TestComments, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnitTest.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.BloodUnit.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitTest.BloodUnitTestGuid] = Guid.NewGuid();
			dr[TABLES.BloodUnitTest.RecordStatusCode] = "A";
			dr[TABLES.BloodUnitTest.InactivateDate] = DateTime.Now;
			dr[TABLES.BloodUnitTest.InactivateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.TestComments] = DateTime.Now.ToString();
			dr[TABLES.BloodUnitTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.BloodUnitTest.RowVersion] = new byte[8];
			dr[TABLES.BloodUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateDiscardStatus
		/// </summary>
		/// <returns></returns>
		public static DataSet GetUpdateDiscardStatusSprocTables(Guid cannedCommentGuid)
		{
			DataSet data = new DataSet();
			//
			DataTable dtFinance = new DataTable(TABLES.BloodUnitFinance.TableName);
			dtFinance.Columns.Add(TABLES.BloodUnitFinance.BloodUnitFinanceGuid, typeof(Guid));
			dtFinance.Columns.Add(TABLES.BloodUnitFinance.ReturnCreditAmount, typeof(decimal));
			dtFinance.Columns.Add(TABLES.BloodUnitFinance.LastUpdateUser);
			dtFinance.Columns.Add(TABLES.BloodUnitFinance.LastUpdateFunctionId, typeof(int));
			dtFinance.Columns.Add(TABLES.BloodUnitFinance.RowVersion, typeof(byte[]));
			//
			DataTable dtDiscard = new DataTable(TABLES.BloodUnitStatus.TableName);
			dtDiscard.Columns.Add(TABLES.BloodUnitStatus.BloodUnitStatusGuid, typeof(Guid));
			dtDiscard.Columns.Add(TABLES.BloodUnitStatus.UnitStatusDate, typeof(DateTime));
			dtDiscard.Columns.Add(TABLES.BloodUnitStatus.UnitStatusComments);
			dtDiscard.Columns.Add(TABLES.BloodUnitStatus.DiscardCannedCommentGuid, typeof(Guid));
			dtDiscard.Columns.Add(TABLES.BloodUnitStatus.LastUpdateUser);
			dtDiscard.Columns.Add(TABLES.BloodUnitStatus.LastUpdateFunctionId, typeof(int));
			dtDiscard.Columns.Add(TABLES.BloodUnitStatus.RowVersion, typeof(byte[]));
			dtDiscard.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));
			//
			DataRow drFinance = dtFinance.NewRow();
			drFinance[TABLES.BloodUnitFinance.BloodUnitFinanceGuid] = Guid.NewGuid();
			drFinance[TABLES.BloodUnitFinance.ReturnCreditAmount] = decimal.One;
			drFinance[TABLES.BloodUnitFinance.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drFinance[TABLES.BloodUnitFinance.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			drFinance[TABLES.BloodUnitFinance.RowVersion] = new byte[8];
			dtFinance.Rows.Add(drFinance);
			data.Tables.Add( dtFinance.Copy() );
			//
			DataRow drDiscard = dtDiscard.NewRow();
			drDiscard[TABLES.BloodUnitStatus.BloodUnitStatusGuid] =  Guid.NewGuid();
			drDiscard[TABLES.BloodUnitStatus.UnitStatusDate] = DateTime.UtcNow;
			drDiscard[TABLES.BloodUnitStatus.UnitStatusComments] = DateTime.UtcNow.ToString();
			drDiscard[TABLES.BloodUnitStatus.DiscardCannedCommentGuid] = cannedCommentGuid;
			drDiscard[TABLES.BloodUnitStatus.LastUpdateUser] = Common.LogonUser.LogonUserName;
			drDiscard[TABLES.BloodUnitStatus.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			drDiscard[TABLES.VamcDivision.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drDiscard[TABLES.BloodUnitStatus.RowVersion] = new byte[8];
			dtDiscard.Rows.Add(drDiscard);
			data.Tables.Add( dtDiscard.Copy() );
			//
			return(data);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateEquipment
		/// </summary>
		/// <param name="equipmentGuid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetUpdateEquipmentSprocTable(Guid equipmentGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.Equipment.TableName);

			dt.Columns.Add(TABLES.Equipment.EquipmentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Equipment.EquipmentName, typeof(string));
			dt.Columns.Add(TABLES.Equipment.EquipmentType, typeof(string));
			dt.Columns.Add(TABLES.Equipment.ManufacturerName, typeof(string));
			dt.Columns.Add(TABLES.Equipment.AddressGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Equipment.SerialNumber, typeof(string));
			dt.Columns.Add(TABLES.Equipment.ReceiptDate, typeof(DateTime));
			dt.Columns.Add(TABLES.Equipment.LocalIdentifier, typeof(string));
			dt.Columns.Add(TABLES.Equipment.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.Equipment.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.Equipment.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.Equipment.RowVersion , typeof(byte[]));

			DataRow dr = dt.NewRow();
			dr[TABLES.Equipment.EquipmentGuid] = equipmentGuid;
			dr[TABLES.Equipment.EquipmentName] = DateTime.Now.ToString();
			dr[TABLES.Equipment.EquipmentType] = "Gooey";
			dr[TABLES.Equipment.ManufacturerName] = DateTime.Now.ToString();
			dr[TABLES.Equipment.AddressGuid] = Guid.NewGuid();
			dr[TABLES.Equipment.SerialNumber] = DateTime.Now.ToString();
			dr[TABLES.Equipment.ReceiptDate] = DateTime.Now;
			dr[TABLES.Equipment.LocalIdentifier] = "123";
			dr[TABLES.Equipment.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.Equipment.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.Equipment.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.Equipment.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateEquipmentMaintenance
		/// </summary>
		/// <param name="emGuid"></param>
		/// <param name="equipGuid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetUpdateEquipmentMaintenanceSprocTable(Guid emGuid, Guid equipGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.EquipmentMaintenance.TableName);

			dt.Columns.Add(TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid, typeof(Guid));
			dt.Columns.Add(TABLES.EquipmentMaintenance.EquipmentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.EquipmentMaintenance.MaintenanceType, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.MaintenanceDate, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.MaintenanceResults, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.Equipment.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.EquipmentMaintenance.RowVersion, typeof(byte[]));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.EquipmentMaintenance.EquipmentMaintenanceGuid] = emGuid;
			dr[TABLES.EquipmentMaintenance.EquipmentGuid] = equipGuid;
			dr[TABLES.EquipmentMaintenance.MaintenanceType] = "Good";
			dr[TABLES.EquipmentMaintenance.MaintenanceDate] = DateTime.Now;
			dr[TABLES.EquipmentMaintenance.MaintenanceResults] = "I am happy";
			dr[TABLES.EquipmentMaintenance.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.EquipmentMaintenance.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.Equipment.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.EquipmentMaintenance.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateIssuedUnit
		/// </summary>
		/// <param name="issuedUnitGuid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetUpdateIssuedUnitSprocTable(Guid issuedUnitGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.IssuedUnit.TableName);

			dt.Columns.Add(TABLES.IssuedUnit.IssuedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.IssuedUnit.ReturnDateTime, typeof(DateTime));
			dt.Columns.Add(TABLES.IssuedUnit.ReturnTechId, typeof(string));
			dt.Columns.Add(TABLES.IssuedUnit.ReturnFromLocationName, typeof(string));
			dt.Columns.Add(TABLES.IssuedUnit.ReturnSatisfactoryIndicator, typeof(bool));
			dt.Columns.Add(TABLES.IssuedUnit.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.VamcDivision.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.IssuedUnit.IssuedUnitGuid] = issuedUnitGuid;
			dr[TABLES.IssuedUnit.ReturnDateTime] = DateTime.Now;
			dr[TABLES.IssuedUnit.ReturnTechId] = "Captain Leela";
			dr[TABLES.IssuedUnit.ReturnFromLocationName] = "Omniron 8";
			dr[TABLES.IssuedUnit.ReturnSatisfactoryIndicator] = true;
			dr[TABLES.IssuedUnit.RowVersion] = rowVersion;
			dr[TABLES.VamcDivision.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spUpdateOrderedComponentStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateOrderedComponentStatusSprocTable(Guid componentGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.OrderedComponent.TableName);

			dt.Columns.Add(TABLES.OrderedComponent.OrderedComponentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedComponent.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedComponent.CancellationCannedCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedComponent.OrderStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.TaskStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.InappropriateRequestIndicator, typeof(bool));
			dt.Columns.Add(TABLES.OrderedComponent.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedComponent.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedComponent.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.OrderedComponent.EmergencyOrderIndicator, typeof(bool));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedComponent.OrderedComponentGuid] = componentGuid;
			//null			dr[TABLES.OrderedComponent.PatientSpecimenGuid] = Guid.NewGuid();
			//null			dr[TABLES.OrderedComponent.CancellationCannedCommentGuid] = Guid.NewGuid();
			dr[TABLES.OrderedComponent.OrderStatusCode] = "A";
			dr[TABLES.OrderedComponent.TaskStatusCode] = "I";
			dr[TABLES.OrderedComponent.InappropriateRequestIndicator] = false;
			dr[TABLES.OrderedComponent.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedComponent.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedComponent.RowVersion] = rowVersion;
			dr[TABLES.OrderedComponent.EmergencyOrderIndicator] = false;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateOrderedTestStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateOrderedTestStatusSprocTable(Guid orderedTestGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.OrderedTest.TableName);

			dt.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.CancellationCannedCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.OrderStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.TaskStatusCode, typeof(String));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedTest.RowVersion, typeof(byte[]));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedTest.OrderedTestGuid] = orderedTestGuid;
			//			dr[TABLES.OrderedTest.PatientSpecimenGuid] = Guid.NewGuid();
			//			dr[TABLES.OrderedTest.CancellationCannedCommentGuid] = Guid.NewGuid();
			dr[TABLES.OrderedTest.OrderStatusCode] = "A";
			dr[TABLES.OrderedTest.TaskStatusCode] = "I";
			dr[TABLES.OrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedTest.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spUpdateOrderedTestTaskStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateOrderedTestTaskStatusSprocTable(Guid otGuid, string taskStatusCode, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.OrderedTest.TableName);

			dt.Columns.Add(TABLES.OrderedTest.OrderedTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedTest.TaskStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedTest.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.OrderedTest.LastUpdateUser, typeof(string));

			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedTest.OrderedTestGuid] = otGuid;
			dr[TABLES.OrderedTest.TaskStatusCode] = taskStatusCode;
			dr[TABLES.OrderedTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedTest.RowVersion] = rowVersion;
			dr[TABLES.OrderedTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
	
			dt.Rows.Add(dr);
			
			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spUpdateOrderedUnit
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateOrderedUnitSprocTable(Guid ouGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.OrderedUnit.TableName);

			dt.Columns.Add(TABLES.OrderedUnit.OrderedUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.OrderedUnit.CrossmatchDate, typeof(DateTime));
			dt.Columns.Add(TABLES.OrderedUnit.CrossmatchTechId, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.CrossmatchResultCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.OrderedUnit.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.OrderedUnit.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.OrderedUnit.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.OrderedUnit.OrderedUnitGuid] = ouGuid;
			dr[TABLES.OrderedUnit.CrossmatchDate] = DateTime.Now;
			dr[TABLES.OrderedUnit.CrossmatchTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.CrossmatchResultCode] = "I";
			dr[TABLES.OrderedUnit.RecordStatusCode] = "A";
			dr[TABLES.OrderedUnit.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.OrderedUnit.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.OrderedUnit.RowVersion] = rowVersion;
			dr[TABLES.OrderedUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		
		/// <summary>
		/// Creates a DataTable for spUpdatePatientAboRHChangeIndicator
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdatePatientAboRHChangeIndicatorSprocTable()
		{
			DataTable dt = new DataTable(TABLES.Patient.TableName);

			dt.Columns.Add(TABLES.Patient.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Patient.AboRhChangeIndicator, typeof(bool));
			dt.Columns.Add(TABLES.Patient.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.Patient.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.Patient.RowVersion, typeof(byte[]));

			DataRow dr = dt.NewRow();
			dr[TABLES.Patient.PatientGuid] = Guid.NewGuid();
			dr[TABLES.Patient.AboRhChangeIndicator] = true;
			dr[TABLES.Patient.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.Patient.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.Patient.RowVersion] = new byte[8];
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdatePatientChangeStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdatePatientChangeStatusSprocTable()
		{
			DataTable dt = new DataTable(TABLES.PatientChange.TableName);

			dt.Columns.Add(TABLES.PatientChange.PatientChangeGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientChange.PatientChangeStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientChange.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.PatientChange.RowVersion, typeof(byte[]));

			DataRow dr = dt.NewRow();
			dr[TABLES.PatientChange.PatientChangeGuid] = Guid.NewGuid();
			dr[TABLES.PatientChange.PatientChangeStatusCode] = "P";
			dr[TABLES.PatientChange.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientChange.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.PatientChange.RowVersion] = new byte[8];
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// DataTable for spUpdatePatientSpecimen
		/// </summary>
		/// <param name="psGuid"></param>
		/// <param name="patientGuid"></param>
		/// <param name="specimenUid"></param>
		/// <param name="rowVersion"></param>
		/// <returns></returns>
		public static DataTable GetUpdatePatientSpecimenSprocTable(Guid psGuid, Guid patientGuid, string specimenUid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.PatientSpecimen.TableName);

			dt.Columns.Add(TABLES.PatientSpecimen.PatientSpecimenGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientSpecimen.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenUid, typeof(string));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenCollectionDate, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenExpirationDate, typeof(DateTime));
			dt.Columns.Add(TABLES.PatientSpecimen.UnacceptableSpecimenIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientSpecimen.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.PatientSpecimen.SpecimenStatusCode, typeof(string));
			dt.Columns.Add(TABLES.PatientSpecimen.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.PatientSpecimen.LastUpdateFunctionId, typeof(int));

			DataRow dr = dt.NewRow();
			dr[TABLES.PatientSpecimen.PatientSpecimenGuid] = psGuid;
			dr[TABLES.PatientSpecimen.PatientGuid] = patientGuid;
			dr[TABLES.PatientSpecimen.SpecimenUid] = specimenUid;
			dr[TABLES.PatientSpecimen.SpecimenCollectionDate] = DateTime.Now.AddDays(-7);
			dr[TABLES.PatientSpecimen.SpecimenExpirationDate] = DateTime.Now.AddDays(3);
			dr[TABLES.PatientSpecimen.UnacceptableSpecimenIndicator] = false;
			dr[TABLES.PatientSpecimen.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			dr[TABLES.PatientSpecimen.SpecimenStatusCode] = "A";
			dr[TABLES.PatientSpecimen.RowVersion] = rowVersion;
			dr[TABLES.PatientSpecimen.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}
		/// <summary>
		/// Creates a DataTable for spUpdatePatientTransfusionRecord
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdatePatientTransfusionRecordSprocTable(Guid transfusionGuid,  byte[] rowVersion, Guid patientGuid, Guid bloodGuid)
		{
			DataTable dt = new DataTable(TABLES.PatientTransfusion.TableName);

			dt.Columns.Add(TABLES.PatientTransfusion.PatientTransfusionGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusion.PatientGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusion.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.PatientTransfusion.ReactionIndicator, typeof(bool));
			dt.Columns.Add(TABLES.PatientTransfusion.ApplicationOfRecordId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusion.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.PatientTransfusion.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.PatientTransfusion.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.PatientTransfusion.DivisionCode, typeof(string));

			DataRow dr = dt.NewRow();
			dr[TABLES.PatientTransfusion.PatientTransfusionGuid] = transfusionGuid;
			dr[TABLES.PatientTransfusion.PatientGuid] = patientGuid;
			dr[TABLES.PatientTransfusion.BloodUnitGuid] = bloodGuid;
			dr[TABLES.PatientTransfusion.ReactionIndicator] = false;
			dr[TABLES.PatientTransfusion.ApplicationOfRecordId] = 1;
			dr[TABLES.PatientTransfusion.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.PatientTransfusion.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.PatientTransfusion.RowVersion] = rowVersion;
			dr[TABLES.PatientTransfusion.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// spUpdateProductShipper
		/// </summary>
		/// <param name="psGuid"></param>
		/// <param name="recordStatusCode"></param>
		/// <returns></returns>
		public static DataTable GetUpdateProductShipperSprocTable(Guid psGuid, byte[] rowVersion, string recStatusCode)
		{
			DataTable dt = new DataTable(TABLES.ProductShipper.TableName);

			dt.Columns.Add(TABLES.ProductShipper.ProductShipperGuid, typeof(Guid));
			dt.Columns.Add(TABLES.ProductShipper.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.ProductShipper.ProductCost, typeof(decimal));
			dt.Columns.Add(TABLES.ProductShipper.ReturnCreditPercentage, typeof(decimal));
			dt.Columns.Add(TABLES.ProductShipper.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.ProductShipper.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.ProductShipper.RowVersion, typeof(byte[]));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.ProductShipper.ProductShipperGuid] = psGuid;
			dr[TABLES.ProductShipper.RecordStatusCode] = recStatusCode;
			dr[TABLES.ProductShipper.ProductCost] = (decimal)4.20;
			dr[TABLES.ProductShipper.ReturnCreditPercentage] = (decimal)42;
			dr[TABLES.ProductShipper.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.ProductShipper.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.ProductShipper.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spUpdateQuarantineStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateQuarantineStatusSprocTable(Guid cannedCommentGuid)
		{
			DataTable dt = new DataTable(TABLES.BloodUnitStatus.TableName);

			dt.Columns.Add(TABLES.BloodUnitStatus.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.BloodUnitStatus.BloodUnitGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitStatus.UnitStatusDate, typeof(DateTime));
			dt.Columns.Add(TABLES.BloodUnitStatus.UnitStatusComments, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitStatus.QuarantineCannedCommentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.BloodUnitStatus.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.BloodUnitStatus.QuarantineIndicator, typeof(bool));
			dt.Columns.Add(TABLES.BloodUnitStatus.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.BloodUnit.DivisionCode, typeof(string));

			DataRow dr = dt.NewRow();
			dr[TABLES.BloodUnitStatus.RowVersion] = new byte[8];
			dr[TABLES.BloodUnitStatus.BloodUnitGuid] = Guid.NewGuid();
			dr[TABLES.BloodUnitStatus.UnitStatusDate] = DateTime.Now;
			dr[TABLES.BloodUnitStatus.UnitStatusComments] = DateTime.Now.ToString();
			dr[TABLES.BloodUnitStatus.QuarantineCannedCommentGuid] = cannedCommentGuid;
			dr[TABLES.BloodUnitStatus.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.BloodUnitStatus.QuarantineIndicator] = true;
			dr[TABLES.BloodUnitStatus.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.BloodUnit.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateRackLot 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateRackLotSprocTable(Guid rlGuid, Guid reagentGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.RackLot.TableName);

			dt.Columns.Add(TABLES.RackLot.RackLotGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackLot.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackLot.LotUseDate, typeof(DateTime));
			dt.Columns.Add(TABLES.RackLot.DivisionCode, typeof(string));
			dt.Columns.Add(TABLES.RackLot.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.RackLot.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.RackLot.RowVersion, typeof(byte[]));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.RackLot.RackLotGuid] = rlGuid;
			dr[TABLES.RackLot.ReagentGuid] = reagentGuid;
			dr[TABLES.RackLot.LotUseDate] = DateTime.Now;
			dr[TABLES.RackLot.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dr[TABLES.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.RackLot.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.RackLot.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateRackTest 
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateRackTestSprocTable(Guid rtGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.RackTest.TableName);

			dt.Columns.Add(TABLES.RackTest.RackTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.RackTest.RackTestResult, typeof(string));
			dt.Columns.Add(TABLES.RackTest.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.RackTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.RackTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.RackTest.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.RackTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.RackTest.TestTechId, typeof(string));
			dt.Columns.Add(TABLES.RackTest.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.RackTest.RackTestGuid] = rtGuid;
			dr[TABLES.RackTest.RackTestResult] = "X";
			dr[TABLES.RackTest.RecordStatusCode] ="A";
			dr[TABLES.RackTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.RackTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.RackTest.RowVersion] = rowVersion;
			dr[TABLES.RackTest.TestDate] = DateTime.Today;
			dr[TABLES.RackTest.TestTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.RackTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}


		/// <summary>
		/// Creates a DataTable for spUpdateReagent
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateReagentSprocTable(Guid reagentGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.Rack.TableName);

			dt.Columns.Add(TABLES.Reagent.ReagentGuid, typeof(Guid));
			dt.Columns.Add(TABLES.Reagent.InspectionIndicator, typeof(bool));
			dt.Columns.Add(TABLES.Reagent.NumberVialsAvailable, typeof(int));
			dt.Columns.Add(TABLES.Reagent.Comments, typeof(string));
			dt.Columns.Add(TABLES.Reagent.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.Reagent.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.Reagent.RowVersion, typeof(byte[]));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.Reagent.ReagentGuid] = reagentGuid;
			dr[TABLES.Reagent.InspectionIndicator] = true;
			dr[TABLES.Reagent.NumberVialsAvailable] = 100;
			dr[TABLES.Reagent.Comments] = DateTime.Now.ToString();
			dr[TABLES.Reagent.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.Reagent.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.Reagent.RowVersion] = rowVersion;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateSpecimenTestForPatientTesting
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateSpecimenTestForPatientTestingSprocTable(Guid stGuid, byte[] rowVersion, int bloodTestTypeId)
		{
			DataTable dt = new DataTable(TABLES.SpecimenTest.TableName);

			dt.Columns.Add(TABLES.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTest.TestTechId, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.BloodTestTypeId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTest.TestDate, typeof(DateTime));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTest.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.DivisionCode, typeof(string));

			DataRow dr = dt.NewRow();
			dr[TABLES.SpecimenTest.SpecimenTestGuid] = stGuid;
			dr[TABLES.SpecimenTest.TestTechId] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTest.BloodTestTypeId] = bloodTestTypeId;
			dr[TABLES.SpecimenTest.TestDate] = DateTime.Now;
			dr[TABLES.SpecimenTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.SpecimenTest.RowVersion] = rowVersion;
			dr[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTest.DivisionCode] = UnitTestConfig.TestDivisionCode;

			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateSpecimenTestStatus
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateSpecimenTestStatusSprocTable(Guid specimenGuid, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.SpecimenTest.TableName);

			dt.Columns.Add(TABLES.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTest.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.TestComments, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.InactivateDate, typeof(DateTime));
			dt.Columns.Add(TABLES.SpecimenTest.InactivateUser, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTest.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.SpecimenTest.DivisionCode, typeof(string));

			//Create a dummy row for the table
			DataRow dr = dt.NewRow();
			dr[TABLES.SpecimenTest.SpecimenTestGuid] = specimenGuid;
			dr[TABLES.SpecimenTest.RecordStatusCode] = "A";
			dr[TABLES.SpecimenTest.TestComments] = DateTime.Now.ToString();
			dr[TABLES.SpecimenTest.InactivateDate] = DateTime.Now;
			dr[TABLES.SpecimenTest.InactivateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.SpecimenTest.RowVersion] = rowVersion;
			dr[TABLES.SpecimenTest.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateSpecimenTest
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateSpecimenTestSprocTable()
		{
			DataTable dt = new DataTable(TABLES.SpecimenTest.TableName);
			
			dt.Columns.Add(TABLES.SpecimenTest.SpecimenTestGuid, typeof(Guid));
			dt.Columns.Add(TABLES.SpecimenTest.TestResultId, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.AboRhChangeIndicator, typeof(bool));
			dt.Columns.Add(TABLES.SpecimenTest.AboRhChangeJustification, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLES.SpecimenTest.LastUpdateFunctionId, typeof(int));
			dt.Columns.Add(TABLES.SpecimenTest.RowVersion, typeof(byte[]));

			DataRow dr = dt.NewRow();
			dr[TABLES.SpecimenTest.SpecimenTestGuid] = Guid.NewGuid();
			dr[TABLES.SpecimenTest.TestResultId] = "P";
			dr[TABLES.SpecimenTest.AboRhChangeIndicator] = true;
			dr[TABLES.SpecimenTest.AboRhChangeJustification] = DateTime.Now.ToString();
			dr[TABLES.SpecimenTest.LastUpdateUser] = Common.LogonUser.LogonUserName;
			dr[TABLES.SpecimenTest.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dr[TABLES.SpecimenTest.RowVersion] = new byte[8];
			dt.Rows.Add(dr);

			return(dt);
		}

		/// <summary>
		/// Creates a DataTable for spUpdateVbecsUser
		/// </summary>
		/// <returns></returns>
		public static DataTable GetUpdateVbecsUserSprocTable(Guid userGuid, string userId, byte[] rowVersion)
		{
			DataTable dt = new DataTable(TABLES.VbecsUser.TableName);
			dt.Columns.Add(TABLES.VbecsUser.VbecsUserGuid, typeof(Guid));
			dt.Columns.Add(TABLES.VbecsUser.VbecsUserId, typeof(string));
			dt.Columns.Add(TABLES.VbecsUser.UserDUZ, typeof(string));
			dt.Columns.Add(TABLES.VbecsUser.UserName, typeof(string));
			dt.Columns.Add(TABLES.VbecsUser.VistaUserName, typeof(string));
			dt.Columns.Add(TABLES.VbecsUser.UserInitials, typeof(string));
			dt.Columns.Add(TABLES.VbecsUser.UserEmail, typeof(string));
			dt.Columns.Add(TABLES.VbecsUser.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLES.VbecsUser.RowVersion, typeof(byte[]));
			dt.Columns.Add(TABLES.VbecsUser.LastUpdateFunctionId, typeof(int));
				
			DataRow dr = dt.NewRow();

			dr[TABLES.VbecsUser.VbecsUserGuid] = userGuid;
			dr[TABLES.VbecsUser.VbecsUserId] = userId;
			dr[TABLES.VbecsUser.UserDUZ] = new Random().Next(60000,99999).ToString();
			dr[TABLES.VbecsUser.UserName] = "Homer Simpson";
			dr[TABLES.VbecsUser.VistaUserName] = "Homerandus";
			dr[TABLES.VbecsUser.UserInitials] = "HJS";
			dr[TABLES.VbecsUser.UserEmail] = "homer@simpson.com";
			dr[TABLES.VbecsUser.RecordStatusCode] = "A";
			dr[TABLES.VbecsUser.RowVersion] = rowVersion;
			dr[TABLES.VbecsUser.LastUpdateFunctionId] = (int)Common.UpdateFunction.UnitTests;
			dt.Rows.Add(dr);

			return(dt);
		}

        private static int _cprsPlaceHolder = int.MinValue;      //used with method below to make less DB calls
        /// <summary>
        /// Gets the next CPRSOrderNumber
        /// </summary>
        /// <returns></returns>
        public static string GetNewCprsOrderNumber()
        {
            if (_cprsPlaceHolder == int.MinValue)
            {
                DataRow drMax = UnitTestUtil.RunSQLGetDataRow(
                        "select max(q1.bigcprs) from (select max(cprsordernumber) as bigcprs from OrderedTest where CprsOrderNumber not like '%[a-z]%' union select max(cprsordernumber) as bigcprs from OrderedComponent  where CprsOrderNumber not like '%[a-z]%') as q1");
                //Autobuild will be null since data is wiped.. AAAAAAAAAAAAAAAASSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSSS!
                if (drMax.IsNull(0))
                    _cprsPlaceHolder = 419; //!!!
                else
                {
                    _cprsPlaceHolder = System.Convert.ToInt32(drMax[0]);
                }
            }
            _cprsPlaceHolder++;
            return (_cprsPlaceHolder.ToString());
        }

	    /// <summary>
		/// Get the next VistaPatientId --
		/// </summary>
		/// <returns></returns>
		public static int GetVistaPatientId()
		{
			DataTable dtIds = UnitTests.UnitTestUtil.RunSQLGetDataTable("SELECT VistaPatientId FROM Patient WHERE VistaPatientId >= 500000 AND VistaPatientId <= 600000 ORDER BY VistaPatientId");

			int vistaId = 0;

			for (int ndx=500000; ndx < 600000; ndx++)
			{
				DataRow[] dtSearch = dtIds.Select("VistaPatientId = " + ndx.ToString());

				if (dtSearch.Length == 0)
				{
					vistaId = ndx;
					break;
				}
			}

			return(vistaId);
		}

		/// <summary>
		/// Returns a random BloodProductGuid from the BloodProduct table
		/// </summary>
		/// <param name="isCodabar">Codabar(TRUE) or ISBT(False)</param>
		/// <param name="componentId">ComponentClass</param>
		/// <returns>BloodProduct Object</returns>
		public static BOL.BloodProduct GetRandomBloodProduct(bool isCodabar, Common.ComponentClass componentId, string productTypes)
		{
			DataTable DT_BloodProducts = null;
			System.Guid bpGuid = System.Guid.Empty;
			string codabarFlag = (isCodabar) ? "0" : "1";
			string strCC = (componentId == Common.ComponentClass.ConversionClass) ? new Random().Next(1,6).ToString() : ((int)componentId).ToString();
			string strProductTypeFilter = "";

			if (productTypes != string.Empty)
			{
				strProductTypeFilter = "('" + productTypes.Replace(",", "','") + "')";
				//Remove spaces to avoid having to worry about external calling
				strProductTypeFilter = "AND ProductTypeCode IN " + strProductTypeFilter.Replace(" ", "");
			}
			//
			DT_BloodProducts = UnitTestUtil.RunSQLGetDataTable(" SELECT BP.*, BP.ProductCodeIndicator AS BarcodeType , PT.ComponentClassId " + 
					" FROM BloodProduct BP " +
					" JOIN ProductType PT ON BP.ProductTypeCode = PT.ProductTypeCode " +
					" WHERE BP.RecordStatusCode = 'A'");

			System.Data.DataRow[] drRows = DT_BloodProducts.Select("ProductCodeIndicator = " + codabarFlag + " AND ComponentClassId = " + strCC + strProductTypeFilter);

			if (drRows.Length > 0)
			{
				int randomIndex = new Random().Next(drRows.Length - 1);
				BOL.BloodProduct tmpBP = new gov.va.med.vbecs.BOL.BloodProduct(drRows[randomIndex]);
				System.Diagnostics.Debug.WriteLine("RandomBP-->" + tmpBP.ProductCode + "<");
				return(tmpBP);
			}
			else
			{
				string inputfields = "isCodabar>" + isCodabar.ToString() + "<CCId>" + componentId.ToString() + "<PTFilter>" + productTypes + "<";
				Assert.Fail("Error getting BloodProduct: " + inputfields );
				return(null);
			}
		}

	}
}
#endif
